/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.beam.runners.core.StateAccessor;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class PaneInfoTracker {
    private @UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals;
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized StateTag<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized PaneInfo>> PANE_INFO_TAG = StateTags.makeSystemTagInternal(StateTags.value("paneInfo", PaneInfo.PaneInfoCoder.INSTANCE));

    public PaneInfoTracker(@UnknownKeyFor @NonNull @Initialized TimerInternals timerInternals) {
        this.timerInternals = timerInternals;
    }

    public void clear(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized StateAccessor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> state) {
        state.access(PANE_INFO_TAG).clear();
    }

    public void prefetchPaneInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context) {
        context.state().access(PANE_INFO_TAG).readLater();
    }

    public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized PaneInfo> getNextPaneInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context, final @UnknownKeyFor @NonNull @Initialized boolean isFinal) {
        final Object key = context.key();
        final ReadableState previousPaneFuture = (ReadableState)context.state().access(PANE_INFO_TAG);
        final Instant windowMaxTimestamp = context.window().maxTimestamp();
        return new ReadableState<PaneInfo>(){

            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
            public @UnknownKeyFor @NonNull @Initialized ReadableState<@UnknownKeyFor @NonNull @Initialized PaneInfo> readLater() {
                previousPaneFuture.readLater();
                return this;
            }

            public @UnknownKeyFor @NonNull @Initialized PaneInfo read() {
                PaneInfo previousPane = (PaneInfo)previousPaneFuture.read();
                return PaneInfoTracker.this.describePane(key, windowMaxTimestamp, previousPane, isFinal);
            }
        };
    }

    public void storeCurrentPaneInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized ReduceFn. @UnknownKeyFor @NonNull @Initialized Context context, @UnknownKeyFor @NonNull @Initialized PaneInfo currentPane) {
        context.state().access(PANE_INFO_TAG).write((Object)currentPane);
    }

    private <W> @UnknownKeyFor @NonNull @Initialized PaneInfo describePane(@UnknownKeyFor @NonNull @Initialized Object key, @UnknownKeyFor @NonNull @Initialized Instant windowMaxTimestamp, @UnknownKeyFor @NonNull @Initialized PaneInfo previousPane, @UnknownKeyFor @NonNull @Initialized boolean isFinal) {
        PaneInfo.Timing timing;
        boolean isEarlyForInput;
        boolean isFirst = previousPane == null;
        PaneInfo.Timing previousTiming = isFirst ? null : previousPane.getTiming();
        long index = isFirst ? 0L : previousPane.getIndex() + 1L;
        long nonSpeculativeIndex = isFirst ? 0L : previousPane.getNonSpeculativeIndex() + 1L;
        Instant outputWM = this.timerInternals.currentOutputWatermarkTime();
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        boolean isLateForOutput = outputWM != null && windowMaxTimestamp.isBefore((ReadableInstant)outputWM);
        boolean onlyEarlyPanesSoFar = previousTiming == null || previousTiming == PaneInfo.Timing.EARLY;
        boolean bl = isEarlyForInput = !inputWM.isAfter((ReadableInstant)windowMaxTimestamp);
        if (isLateForOutput || !onlyEarlyPanesSoFar) {
            timing = PaneInfo.Timing.LATE;
        } else if (isEarlyForInput) {
            timing = PaneInfo.Timing.EARLY;
            nonSpeculativeIndex = -1L;
        } else {
            timing = PaneInfo.Timing.ON_TIME;
        }
        WindowTracing.debug((String)"describePane: {} pane (prev was {}) for key:{}; windowMaxTimestamp:{}; inputWatermark:{}; outputWatermark:{}; isLateForOutput:{}", (Object[])new Object[]{timing, previousTiming, key, windowMaxTimestamp, inputWM, outputWM, isLateForOutput});
        if (previousPane != null) {
            switch (previousTiming) {
                case EARLY: {
                    Preconditions.checkState((timing == PaneInfo.Timing.EARLY || timing == PaneInfo.Timing.ON_TIME || timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"EARLY cannot transition to %s", (Object)timing);
                    break;
                }
                case ON_TIME: {
                    Preconditions.checkState((timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"ON_TIME cannot transition to %s", (Object)timing);
                    break;
                }
                case LATE: {
                    Preconditions.checkState((timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"LATE cannot transtion to %s", (Object)timing);
                    break;
                }
            }
            Preconditions.checkState((!previousPane.isLast() ? 1 : 0) != 0, (Object)"Last pane was not last after all.");
        }
        return PaneInfo.createPane((boolean)isFirst, (boolean)isFinal, (PaneInfo.Timing)timing, (long)index, (long)nonSpeculativeIndex);
    }
}

