/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.function.ThrowingFunction;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class MapFnRunners {
    public static <InputT, OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> forValueMapFnFactory(@UnknownKeyFor @NonNull @Initialized ValueMapFnFactory<InputT, OutputT> fnFactory) {
        return new Factory(new CompressedValueOnlyMapperFactory(fnFactory));
    }

    public static <InputT, OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> forWindowedValueMapFnFactory(@UnknownKeyFor @NonNull @Initialized WindowedValueMapFnFactory<InputT, OutputT> fnFactory) {
        return new Factory(new ExplodedWindowedValueMapperFactory(fnFactory));
    }

    private static class CompressedValueOnlyMapperFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements MapperFactory<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized ValueMapFnFactory<InputT, OutputT> fnFactory;

        private CompressedValueOnlyMapperFactory(@UnknownKeyFor @NonNull @Initialized ValueMapFnFactory<InputT, OutputT> fnFactory) {
            this.fnFactory = fnFactory;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Mapper<InputT, OutputT> create(@UnknownKeyFor @NonNull @Initialized String ptransformId, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform ptransform, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> outputs) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ThrowingFunction fn = this.fnFactory.forPTransform(ptransformId, ptransform);
            return input -> outputs.accept((Object)input.withValue(fn.apply(input.getValue())));
        }
    }

    private static class ExplodedWindowedValueMapperFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements MapperFactory<InputT, OutputT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowedValueMapFnFactory<InputT, OutputT> fnFactory;

        private ExplodedWindowedValueMapperFactory(@UnknownKeyFor @NonNull @Initialized WindowedValueMapFnFactory<InputT, OutputT> fnFactory) {
            this.fnFactory = fnFactory;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Mapper<InputT, OutputT> create(@UnknownKeyFor @NonNull @Initialized String ptransformId, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform ptransform, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> outputs) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ThrowingFunction fn = this.fnFactory.forPTransform(ptransformId, ptransform);
            return input -> {
                for (WindowedValue exploded : input.explodeWindows()) {
                    outputs.accept((Object)((WindowedValue)fn.apply((Object)exploded)));
                }
            };
        }
    }

    private static interface Mapper<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public void map(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> var1) throws @UnknownKeyFor @NonNull @Initialized Exception;
    }

    @FunctionalInterface
    private static interface MapperFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized Mapper<InputT, OutputT> create(@UnknownKeyFor @NonNull @Initialized String var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform var2, @UnknownKeyFor @NonNull @Initialized FnDataReceiver<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> var3) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    private static class Factory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements PTransformRunnerFactory<Mapper<InputT, OutputT>> {
        private final @UnknownKeyFor @NonNull @Initialized MapperFactory mapperFactory;

        private Factory(@UnknownKeyFor @NonNull @Initialized MapperFactory<InputT, OutputT> mapperFactory) {
            this.mapperFactory = mapperFactory;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Mapper<InputT, OutputT> createRunnerForPTransform(@UnknownKeyFor @NonNull @Initialized PTransformRunnerFactory.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FnDataReceiver consumer = context.getPCollectionConsumer((String)Iterables.getOnlyElement(context.getPTransform().getOutputsMap().values()));
            Mapper mapper = this.mapperFactory.create(context.getPTransformId(), context.getPTransform(), consumer);
            String pCollectionId = (String)Iterables.getOnlyElement(context.getPTransform().getInputsMap().values());
            context.addPCollectionConsumer(pCollectionId, mapper::map);
            return mapper;
        }
    }

    public static interface WindowedValueMapFnFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized ThrowingFunction<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>, @UnknownKeyFor @NonNull @Initialized WindowedValue<OutputT>> forPTransform(@UnknownKeyFor @NonNull @Initialized String var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform var2) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }

    public static interface ValueMapFnFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT> {
        public @UnknownKeyFor @NonNull @Initialized ThrowingFunction<InputT, OutputT> forPTransform(@UnknownKeyFor @NonNull @Initialized String var1, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform var2) throws @UnknownKeyFor @NonNull @Initialized IOException;
    }
}

