/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.fn.stream.PrefetchableIterator;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class DataStreams {
    public static final int DEFAULT_OUTBOUND_BUFFER_LIMIT_BYTES = 1000000;

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer) {
        return DataStreams.outbound(consumer, 1000000);
    }

    public static ElementDelimitedOutputStream outbound(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
        return new ElementDelimitedOutputStream(consumer, maximumChunkSize);
    }

    public static class BlockingQueueIterator<T>
    implements AutoCloseable,
    Iterator<T> {
        private static final Object POISION_PILL = new Object();
        private final BlockingQueue<T> queue;
        private T currentElement;

        public BlockingQueueIterator(BlockingQueue<T> queue) {
            this.queue = queue;
        }

        @Override
        public void close() throws Exception {
            this.queue.put(POISION_PILL);
        }

        public void accept(T t) throws Exception {
            this.queue.put(t);
        }

        @Override
        public boolean hasNext() {
            if (this.currentElement == null) {
                try {
                    this.currentElement = this.queue.take();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(e);
                }
            }
            return this.currentElement != POISION_PILL;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T rval = this.currentElement;
            this.currentElement = null;
            return rval;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DataStreamDecoder<T>
    implements PrefetchableIterator<T> {
        private final PrefetchableIterator<ByteString> inputByteStrings;
        private final Inbound inbound;
        private final Coder<T> coder;
        private State currentState = State.READ_REQUIRED;
        private T next;
        private static final InputStream EMPTY_STREAM = ByteString.EMPTY.newInput();

        public DataStreamDecoder(Coder<T> coder, PrefetchableIterator<ByteString> inputStream) {
            this.coder = coder;
            this.inputByteStrings = inputStream;
            this.inbound = new Inbound();
        }

        @Override
        public boolean isReady() {
            switch (this.currentState) {
                case EOF: {
                    return true;
                }
                case READ_REQUIRED: {
                    try {
                        return this.inbound.isReady();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                case HAS_NEXT: {
                    return true;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s", new Object[]{this.currentState}));
        }

        @Override
        public void prefetch() {
            if (!this.isReady()) {
                this.inputByteStrings.prefetch();
            }
        }

        @Override
        public boolean hasNext() {
            switch (this.currentState) {
                case EOF: {
                    return false;
                }
                case READ_REQUIRED: {
                    try {
                        if (this.inbound.isEof()) {
                            this.currentState = State.EOF;
                            return false;
                        }
                        long previousPosition = this.inbound.position;
                        this.next = this.coder.decode((InputStream)this.inbound);
                        if (this.inbound.position - previousPosition == 0L) {
                            Preconditions.checkState((this.inbound.read() != -1 ? 1 : 0) != 0, (Object)"Unexpected EOF reached");
                        }
                        this.currentState = State.HAS_NEXT;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return true;
                }
                case HAS_NEXT: {
                    return true;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s", new Object[]{this.currentState}));
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentState = State.READ_REQUIRED;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static /* synthetic */ InputStream access$100() {
            return EMPTY_STREAM;
        }

        private class Inbound
        extends InputStream {
            private long position;
            private InputStream currentStream = DataStreamDecoder.access$100();

            public boolean isReady() throws IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.isReady()) {
                        return false;
                    }
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                }
                return true;
            }

            public boolean isEof() throws IOException {
                while (this.currentStream.available() == 0) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return true;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                }
                return false;
            }

            @Override
            public int read() throws IOException {
                int read;
                while ((read = this.currentStream.read()) == -1) {
                    if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                        return -1;
                    }
                    this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                }
                ++this.position;
                return read;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int read;
                for (int remainingLen = len; remainingLen > 0; remainingLen -= read) {
                    while ((read = this.currentStream.read(b, off + len - remainingLen, remainingLen)) == -1) {
                        if (!DataStreamDecoder.this.inputByteStrings.hasNext()) {
                            int bytesRead = len - remainingLen;
                            this.position += (long)bytesRead;
                            return bytesRead > 0 ? bytesRead : -1;
                        }
                        this.currentStream = ((ByteString)DataStreamDecoder.this.inputByteStrings.next()).newInput();
                    }
                }
                this.position += (long)len;
                return len;
            }
        }

        private static enum State {
            READ_REQUIRED,
            HAS_NEXT,
            EOF;

        }
    }

    public static interface OutputChunkConsumer<T> {
        public void read(T var1) throws IOException;
    }

    public static final class ElementDelimitedOutputStream
    extends OutputStream {
        private final OutputChunkConsumer<ByteString> consumer;
        private final ByteString.Output output;
        private final int maximumChunkSize;
        int previousPosition;

        public ElementDelimitedOutputStream(OutputChunkConsumer<ByteString> consumer, int maximumChunkSize) {
            this.consumer = consumer;
            this.maximumChunkSize = maximumChunkSize;
            this.output = ByteString.newOutput((int)maximumChunkSize);
        }

        public void delimitElement() throws IOException {
            if (this.previousPosition == this.output.size()) {
                this.write(0);
            }
            this.previousPosition = this.output.size();
        }

        @Override
        public void write(int i) throws IOException {
            this.output.write(i);
            if (this.maximumChunkSize == this.output.size()) {
                this.internalFlush();
            }
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            int spaceRemaining = this.maximumChunkSize - this.output.size();
            if (length > spaceRemaining) {
                this.output.write(b, offset, spaceRemaining);
                offset += spaceRemaining;
                length -= spaceRemaining;
                this.internalFlush();
            }
            while (length > this.maximumChunkSize) {
                this.output.write(b, offset, this.maximumChunkSize);
                offset += this.maximumChunkSize;
                length -= this.maximumChunkSize;
                this.internalFlush();
            }
            this.output.write(b, offset, length);
        }

        @Override
        public void close() throws IOException {
            if (this.output.size() > 0) {
                this.consumer.read(this.output.toByteString());
            }
            this.output.close();
        }

        private void internalFlush() throws IOException {
            this.consumer.read(this.output.toByteString());
            this.output.reset();
            this.previousPosition = -1;
        }
    }
}

