/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.ValidationException;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdfImpl;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.UdfUdafProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;

@Internal
@Experimental
public class BeamSqlEnv {
    final CalciteConnection connection;
    final SchemaPlus defaultSchema;
    final BeamQueryPlanner planner;

    private BeamSqlEnv(TableProvider tableProvider) {
        this.connection = JdbcDriver.connect(tableProvider);
        this.defaultSchema = JdbcDriver.getDefaultSchema(this.connection);
        this.planner = new BeamQueryPlanner(this.connection);
    }

    public static BeamSqlEnv readOnly(String tableType, Map<String, BeamSqlTable> tables) {
        return BeamSqlEnv.withTableProvider(new ReadOnlyTableProvider(tableType, tables));
    }

    public static BeamSqlEnv withTableProvider(TableProvider tableProvider) {
        return new BeamSqlEnv(tableProvider);
    }

    public static BeamSqlEnv inMemory(TableProvider ... tableProviders) {
        InMemoryMetaStore inMemoryMetaStore = new InMemoryMetaStore();
        for (TableProvider tableProvider : tableProviders) {
            inMemoryMetaStore.registerProvider(tableProvider);
        }
        return BeamSqlEnv.withTableProvider(inMemoryMetaStore);
    }

    private void registerBuiltinUdf(Map<String, List<Method>> methods) {
        for (Map.Entry<String, List<Method>> entry : methods.entrySet()) {
            for (Method method : entry.getValue()) {
                this.defaultSchema.add(entry.getKey(), UdfImpl.create(method));
            }
        }
    }

    public void registerUdf(String functionName, Class<?> clazz, String method) {
        this.defaultSchema.add(functionName, UdfImpl.create(clazz, method));
    }

    public void registerUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
        this.registerUdf(functionName, clazz, "eval");
    }

    public void registerUdf(String functionName, SerializableFunction sfn) {
        this.registerUdf(functionName, sfn.getClass(), "apply");
    }

    public void registerUdaf(String functionName, Combine.CombineFn combineFn) {
        this.defaultSchema.add(functionName, new UdafImpl(combineFn));
    }

    public void loadUdfUdafFromProvider() {
        ServiceLoader.load(UdfUdafProvider.class).forEach(ins -> {
            ins.getBeamSqlUdfs().forEach((udfName, udfClass) -> this.registerUdf((String)udfName, (Class<? extends BeamSqlUdf>)udfClass));
            ins.getSerializableFunctionUdfs().forEach((udfName, udfFn) -> this.registerUdf((String)udfName, (SerializableFunction)udfFn));
            ins.getUdafs().forEach((udafName, udafFn) -> this.registerUdaf((String)udafName, (Combine.CombineFn)udafFn));
        });
    }

    public void loadBeamBuiltinFunctions() {
        for (BeamBuiltinFunctionProvider provider : ServiceLoader.load(BeamBuiltinFunctionProvider.class)) {
            this.registerBuiltinUdf(provider.getBuiltinMethods());
        }
    }

    public BeamRelNode parseQuery(String query) throws ParseException {
        try {
            return this.planner.convertToBeamRel(query);
        }
        catch (SqlParseException | RelConversionException | ValidationException e) {
            throw new ParseException(String.format("Unable to parse query %s", query), e);
        }
    }

    public boolean isDdl(String sqlStatement) throws ParseException {
        try {
            return this.planner.parse(sqlStatement) instanceof SqlExecutableStatement;
        }
        catch (SqlParseException e) {
            throw new ParseException("Unable to parse statement", e);
        }
    }

    public void executeDdl(String sqlStatement) throws ParseException {
        try {
            SqlExecutableStatement ddl = (SqlExecutableStatement)((Object)this.planner.parse(sqlStatement));
            ddl.execute(this.getContext());
        }
        catch (SqlParseException e) {
            throw new ParseException("Unable to parse DDL statement", e);
        }
    }

    public CalcitePrepare.Context getContext() {
        return this.connection.createPrepareContext();
    }

    public Map<String, String> getPipelineOptions() {
        return ((BeamCalciteSchema)CalciteSchema.from((SchemaPlus)this.defaultSchema).schema).getPipelineOptions();
    }

    public String explain(String sqlString) throws ParseException {
        try {
            return RelOptUtil.toString(this.planner.convertToBeamRel(sqlString));
        }
        catch (SqlParseException | RelConversionException | ValidationException e) {
            throw new ParseException("Unable to parse statement", e);
        }
    }
}

