/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusIntervalExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlTimestampMinusIntervalExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlTimestampMinusTimestampExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlDatetimeMinusExpression
extends BeamSqlExpression {
    private BeamSqlExpression delegateExpression;

    public BeamSqlDatetimeMinusExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
        this.delegateExpression = this.createDelegateExpression(operands, outputType);
    }

    private BeamSqlExpression createDelegateExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        if (this.isTimestampMinusTimestamp(operands, outputType)) {
            return new BeamSqlTimestampMinusTimestampExpression(operands, outputType);
        }
        if (this.isTimestampMinusInterval(operands, outputType)) {
            return new BeamSqlTimestampMinusIntervalExpression(operands, outputType);
        }
        if (this.isDatetimeMinusInterval(operands, outputType)) {
            return new BeamSqlDatetimeMinusIntervalExpression(operands, outputType);
        }
        return null;
    }

    private boolean isTimestampMinusTimestamp(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return BeamSqlTimestampMinusTimestampExpression.accept(operands, outputType);
    }

    private boolean isTimestampMinusInterval(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return BeamSqlTimestampMinusIntervalExpression.accept(operands, outputType);
    }

    private boolean isDatetimeMinusInterval(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return BeamSqlDatetimeMinusIntervalExpression.accept(operands, outputType);
    }

    @Override
    public boolean accept() {
        return this.delegateExpression != null && this.delegateExpression.accept();
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        if (this.delegateExpression == null) {
            throw new IllegalStateException("Unable to execute unsupported 'datetime minus' expression");
        }
        return this.delegateExpression.evaluate(inputRow, window, env);
    }
}

