/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.Meta;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.QueryState;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.remote.TypedValue;

public abstract class AvaticaStatement
implements Statement {
    public static final int DEFAULT_FETCH_SIZE = 100;
    public final AvaticaConnection connection;
    public Meta.StatementHandle handle;
    protected boolean closed;
    protected final AtomicBoolean cancelFlag;
    protected boolean closeOnCompletion;
    protected AvaticaResultSet openResultSet;
    protected long updateCount;
    private int queryTimeoutMillis;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private int fetchSize = 100;
    private int fetchDirection;
    protected long maxRowCount = 0L;
    private Meta.Signature signature;
    private final List<String> batchedSql;

    protected void setSignature(Meta.Signature signature) {
        this.signature = signature;
    }

    protected Meta.Signature getSignature() {
        return this.signature;
    }

    public Meta.StatementType getStatementType() {
        return this.signature.statementType;
    }

    protected AvaticaStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(connection, h, resultSetType, resultSetConcurrency, resultSetHoldability, null);
    }

    protected AvaticaStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability, Meta.Signature signature) {
        this.connection = Objects.requireNonNull(connection);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.signature = signature;
        this.closed = false;
        if (h == null) {
            Meta.ConnectionHandle ch = connection.handle;
            h = connection.meta.createStatement(ch);
        }
        connection.statementMap.put(h.id, this);
        this.handle = h;
        this.batchedSql = new ArrayList<String>();
        try {
            this.cancelFlag = connection.getCancelFlag(h);
        }
        catch (NoSuchStatementException e) {
            throw new AssertionError("no statement", e);
        }
    }

    public int getId() {
        return this.handle.id;
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw AvaticaConnection.HELPER.createException("Statement closed");
        }
    }

    private void checkNotPreparedOrCallable(String s) throws SQLException {
        if (this instanceof PreparedStatement || this instanceof CallableStatement) {
            throw AvaticaConnection.HELPER.createException("Cannot call " + s + " on prepared or callable statement");
        }
    }

    protected void executeInternal(String sql) throws SQLException {
        this.updateCount = -1L;
        try {
            long maxRowCount1 = this.maxRowCount <= 0L ? -1L : this.maxRowCount;
            int i = 0;
            while ((long)i < this.connection.maxRetriesPerExecute) {
                try {
                    Meta.ExecuteResult x = this.connection.prepareAndExecuteInternal(this, sql, maxRowCount1);
                    return;
                }
                catch (NoSuchStatementException e) {
                    this.resetStatement();
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            throw AvaticaConnection.HELPER.createException("Error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
        throw new RuntimeException("Failed to successfully execute query after " + this.connection.maxRetriesPerExecute + " attempts.");
    }

    protected long[] executeBatchInternal() throws SQLException {
        int i = 0;
        while ((long)i < this.connection.maxRetriesPerExecute) {
            try {
                return this.connection.prepareAndUpdateBatch((AvaticaStatement)this, this.batchedSql).updateCounts;
            }
            catch (NoSuchStatementException e) {
                this.resetStatement();
                ++i;
            }
        }
        throw new RuntimeException("Failed to successfully execute batch update after " + this.connection.maxRetriesPerExecute + " attempts");
    }

    protected void resetStatement() {
        this.connection.statementMap.remove(this.handle.id);
        this.connection.flagMap.remove(this.handle.id);
        Meta.ConnectionHandle ch = new Meta.ConnectionHandle(this.connection.id);
        Meta.StatementHandle h = this.connection.meta.createStatement(ch);
        this.connection.statementMap.put(h.id, this);
        this.handle = h;
    }

    protected boolean syncResults(QueryState state, long offset) throws NoSuchStatementException {
        return this.connection.meta.syncResults(this.handle, state, offset);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkOpen();
        this.checkNotPreparedOrCallable("execute(String)");
        this.executeInternal(sql);
        return this.openResultSet != null && !this.openResultSet.isClosed();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        this.checkNotPreparedOrCallable("executeQuery(String)");
        try {
            this.executeInternal(sql);
            if (this.openResultSet == null) {
                throw AvaticaConnection.HELPER.createException("Statement did not return a result set");
            }
            return this.openResultSet;
        }
        catch (RuntimeException e) {
            throw AvaticaConnection.HELPER.createException("Error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        return AvaticaUtils.toSaturatedInt(this.executeLargeUpdate(sql));
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkOpen();
        this.checkNotPreparedOrCallable("executeUpdate(String)");
        this.executeInternal(sql);
        return this.updateCount;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.close_();
        }
        catch (RuntimeException e) {
            throw AvaticaConnection.HELPER.createException("While closing statement", e);
        }
    }

    protected void close_() {
        if (!this.closed) {
            this.closed = true;
            if (this.openResultSet != null) {
                AvaticaResultSet c = this.openResultSet;
                this.openResultSet = null;
                c.close();
            }
            try {
                this.connection.meta.closeStatement(this.handle);
            }
            finally {
                this.connection.statementMap.remove(this.handle.id);
                this.connection.flagMap.remove(this.handle.id);
            }
            this.connection.driver.handler.onStatementClose(this);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkOpen();
        if (max != 0) {
            throw AvaticaConnection.HELPER.createException("illegal maxField value: " + max);
        }
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return AvaticaUtils.toSaturatedInt(this.getLargeMaxRows());
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRowCount;
    }

    @Override
    public final void setMaxRows(int maxRowCount) throws SQLException {
        this.setLargeMaxRows(maxRowCount);
    }

    @Override
    public void setLargeMaxRows(long maxRowCount) throws SQLException {
        this.checkOpen();
        if (maxRowCount < 0L) {
            throw AvaticaConnection.HELPER.createException("illegal maxRows value: " + maxRowCount);
        }
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        long timeoutSeconds = this.getQueryTimeoutMillis() / 1000;
        if (timeoutSeconds > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (timeoutSeconds == 0L && this.getQueryTimeoutMillis() > 0) {
            return 1;
        }
        return (int)timeoutSeconds;
    }

    int getQueryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkOpen();
        if (seconds < 0) {
            throw AvaticaConnection.HELPER.createException("illegal timeout value " + seconds);
        }
        this.setQueryTimeoutMillis(seconds * 1000);
    }

    void setQueryTimeoutMillis(int millis) {
        this.queryTimeoutMillis = millis;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkOpen();
        if (this.openResultSet != null) {
            this.openResultSet.cancel();
        }
        this.cancelFlag.compareAndSet(false, true);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.openResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return AvaticaUtils.toSaturatedInt(this.updateCount);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkOpen();
        return this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkOpen();
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkOpen();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkOpen();
        this.checkNotPreparedOrCallable("addBatch(String)");
        this.batchedSql.add(Objects.requireNonNull(sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.checkNotPreparedOrCallable("clearBatch()");
        this.batchedSql.clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return AvaticaUtils.toSaturatedInts(this.executeLargeBatch());
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkOpen();
        try {
            long[] lArray = this.executeBatchInternal();
            return lArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public AvaticaConnection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        switch (current) {
            case 2: 
            case 3: {
                throw AvaticaConnection.HELPER.unsupported();
            }
            case 1: {
                break;
            }
            default: {
                throw AvaticaConnection.HELPER.createException("value " + current + " is not one of CLOSE_CURRENT_RESULT, KEEP_CURRENT_RESULT or CLOSE_ALL_RESULTS");
            }
        }
        if (this.openResultSet != null) {
            this.openResultSet.close();
        }
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return this.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw AvaticaConnection.HELPER.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    protected boolean executeInternal(Meta.Signature signature, boolean isUpdate) throws SQLException {
        ResultSet resultSet = this.executeQueryInternal(signature, isUpdate);
        return !resultSet.isClosed();
    }

    protected ResultSet executeQueryInternal(Meta.Signature signature, boolean isUpdate) throws SQLException {
        return this.connection.executeQueryInternal(this, signature, null, null, isUpdate);
    }

    void onResultSetClose(ResultSet resultSet) {
        if (this.closeOnCompletion) {
            this.close_();
        }
    }

    protected List<TypedValue> getParameterValues() {
        return Collections.emptyList();
    }

    protected List<TypedValue> getBoundParameterValues() throws SQLException {
        List<TypedValue> parameterValues = this.getParameterValues();
        for (TypedValue parameterValue : parameterValues) {
            if (parameterValue != null) continue;
            throw new SQLException("unbound parameter");
        }
        return parameterValues;
    }
}

