/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.store;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryMetaStore
implements MetaStore {
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> tables = new HashMap<String, Table>();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> providers = new HashMap<String, TableProvider>();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "store";
    }

    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        this.validateTableType(table);
        if (this.tables.containsKey(table.getName())) {
            throw new IllegalArgumentException("Duplicate table name: " + table.getName());
        }
        this.getProvider(table.getType()).createTable(table);
        this.tables.put(table.getName(), table);
    }

    @Override
    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        if (!this.tables.containsKey(tableName)) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        Table table = this.tables.get(tableName);
        this.getProvider(table.getType()).dropTable(tableName);
        this.tables.remove(tableName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        return ImmutableMap.copyOf(this.tables);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        TableProvider provider = this.getProvider(table.getType());
        return provider.buildBeamSqlTable(table);
    }

    protected void validateTableType(@UnknownKeyFor @NonNull @Initialized Table table) {
        if (this.providers.containsKey(table.getType().toLowerCase())) {
            return;
        }
        @Nullable InMemoryMetaStore nestedMemoryMetastore = (InMemoryMetaStore)this.providers.get(this.getTableType());
        if (nestedMemoryMetastore == null) {
            throw new IllegalArgumentException("Table type: " + table.getType() + " not supported!");
        }
        nestedMemoryMetastore.validateTableType(table);
    }

    @Override
    public void registerProvider(@UnknownKeyFor @NonNull @Initialized TableProvider provider) {
        String type = provider.getTableType().toLowerCase();
        if (this.providers.containsKey(type)) {
            throw new IllegalArgumentException("Provider is already registered for table type: " + type);
        }
        this.initTablesFromProvider(provider);
        this.providers.put(type, provider);
    }

    private void initTablesFromProvider(@UnknownKeyFor @NonNull @Initialized TableProvider provider) {
        Map<String, Table> tables = provider.getTables();
        for (String tableName : tables.keySet()) {
            if (!this.tables.containsKey(tableName)) continue;
            throw new IllegalStateException("Duplicate table: " + tableName + " from provider: " + provider);
        }
        this.tables.putAll(tables);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviders() {
        return this.providers;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean supportsPartitioning(@UnknownKeyFor @NonNull @Initialized Table table) {
        return this.getProvider(table.getType()).supportsPartitioning(table);
    }

    public @UnknownKeyFor @NonNull @Initialized TableProvider getProvider(@UnknownKeyFor @NonNull @Initialized String type) {
        @Nullable TableProvider provider = this.providers.get(type.toLowerCase());
        if (provider != null) {
            return provider;
        }
        provider = this.providers.get(this.getTableType());
        if (provider != null && provider instanceof InMemoryMetaStore) {
            return ((InMemoryMetaStore)provider).getProvider(type);
        }
        throw new IllegalStateException("No TableProvider registered for table type: " + type);
    }
}

