/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datagen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.commons.lang3.RandomStringUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

public class DataGeneratorRowFn
extends DoFn<Long, Row> {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized ObjectNode properties;
    @Nullable
    private final @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String primaryTimestampField;
    private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldGenerator> fieldGenerators;

    public DataGeneratorRowFn(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized ObjectNode properties, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String primaryTimestampField) {
        this.schema = schema;
        this.properties = properties;
        this.primaryTimestampField = primaryTimestampField;
    }

    @DoFn.Setup
    public void setup() {
        this.fieldGenerators = new HashMap<String, FieldGenerator>();
        for (Schema.Field field : this.schema.getFields()) {
            this.fieldGenerators.put(field.getName(), this.createGeneratorForField(field));
        }
    }

    @DoFn.ProcessElement
    public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Long index, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant timestamp, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
        Row.Builder rowBuilder = Row.withSchema((Schema)this.schema);
        for (Schema.Field field : this.schema.getFields()) {
            Object value;
            if (field.getName().equals(this.primaryTimestampField)) {
                value = timestamp.toDateTime();
            } else {
                FieldGenerator generator = this.fieldGenerators.get(field.getName());
                if (generator == null) {
                    throw new IllegalStateException("No generator found for field: " + field.getName());
                }
                value = generator.generate(index);
            }
            rowBuilder.addValue(value);
        }
        out.output((Object)rowBuilder.build());
    }

    private @UnknownKeyFor @NonNull @Initialized FieldGenerator createGeneratorForField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        String fieldName = field.getName();
        FieldGenerator valueGenerator = this.createValueGeneratorForField(field);
        double nullRate = this.properties.path("fields." + fieldName + ".null-rate").asDouble(0.0);
        if (nullRate > 0.0) {
            return index -> ThreadLocalRandom.current().nextDouble() < nullRate ? null : valueGenerator.generate(index);
        }
        return valueGenerator;
    }

    private @UnknownKeyFor @NonNull @Initialized FieldGenerator createValueGeneratorForField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        String fieldName = field.getName();
        String kind = this.properties.path("fields." + fieldName + ".kind").asText("random");
        SqlTypeName sqlTypeName = CalciteUtils.toSqlTypeName(field.getType());
        if (sqlTypeName == null) {
            throw new UnsupportedOperationException("Data generator requires a defined SQL type. Beam type '" + field.getType().getTypeName() + "' on field '" + field.getName() + "' is not supported.");
        }
        if ("sequence".equalsIgnoreCase(kind)) {
            long end;
            if (!SqlTypeName.INT_TYPES.contains(sqlTypeName)) {
                throw new IllegalArgumentException(String.format("The 'sequence' generator for integers only supports integer types, but field '%s' is of type '%s'.", field.getName(), sqlTypeName));
            }
            JsonNode startNode = this.properties.path("fields." + fieldName + ".start");
            JsonNode endNode = this.properties.path("fields." + fieldName + ".end");
            if (startNode.isMissingNode() && endNode.isMissingNode()) {
                return index -> index;
            }
            if (startNode.isMissingNode() || endNode.isMissingNode()) {
                throw new IllegalArgumentException("For a cycling sequence generator, both 'start' and 'end' must be specified.");
            }
            long start = startNode.asLong(0L);
            if (start > (end = endNode.asLong(Long.MAX_VALUE))) {
                throw new IllegalArgumentException(String.format("For sequence generator, 'start' (%d) cannot be greater than 'end' (%d).", start, end));
            }
            long cycleLength = end - start + 1L;
            switch (sqlTypeName) {
                case INTEGER: {
                    return index -> (int)(start + index % cycleLength);
                }
                case SMALLINT: {
                    return index -> (short)(start + index % cycleLength);
                }
                case TINYINT: {
                    return index -> (byte)(start + index % cycleLength);
                }
            }
            return index -> start + index % cycleLength;
        }
        switch (sqlTypeName) {
            case CHAR: 
            case VARCHAR: {
                int length = this.properties.path("fields." + fieldName + ".length").asInt(10);
                return index -> RandomStringUtils.randomAlphanumeric((int)length);
            }
            case BOOLEAN: {
                return index -> ThreadLocalRandom.current().nextBoolean();
            }
            case FLOAT: 
            case DOUBLE: {
                double minD = this.properties.path("fields." + fieldName + ".min").asDouble(0.0);
                double maxD = this.properties.path("fields." + fieldName + ".max").asDouble(1.0);
                return index -> minD + (maxD - minD) * ThreadLocalRandom.current().nextDouble();
            }
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case BIGINT: {
                long minL = this.properties.path("fields." + fieldName + ".min").asLong(0L);
                long maxL = this.properties.path("fields." + fieldName + ".max").asLong(Long.MAX_VALUE);
                return index -> minL + (long)(ThreadLocalRandom.current().nextDouble() * (double)(maxL - minL));
            }
            case DECIMAL: {
                double minBd = this.properties.path("fields." + fieldName + ".min").asDouble(0.0);
                double maxBd = this.properties.path("fields." + fieldName + ".max").asDouble(1000.0);
                return index -> BigDecimal.valueOf(minBd + (maxBd - minBd) * ThreadLocalRandom.current().nextDouble());
            }
            case TIMESTAMP: {
                JsonNode maxPastNode = this.properties.path("fields." + fieldName + ".max-past");
                if (!maxPastNode.isMissingNode()) {
                    long maxPastMs = maxPastNode.asLong();
                    if (maxPastMs <= 0L) {
                        throw new IllegalArgumentException("'max-past' must be a positive long value.");
                    }
                    return index -> Instant.now().minus((ReadableDuration)Duration.millis((long)((long)(ThreadLocalRandom.current().nextDouble() * (double)maxPastMs))));
                }
                return index -> Instant.now();
            }
        }
        throw new UnsupportedOperationException("Unsupported SQL type for datagen: " + sqlTypeName);
    }

    @FunctionalInterface
    private static interface FieldGenerator
    extends Serializable {
        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Object generate(@UnknownKeyFor @NonNull @Initialized long var1);
    }
}

