/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.CalciteConnectionWrapper;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JdbcConnection
extends CalciteConnectionWrapper {
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_OPTION_PREFIX = "beam.";
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptionsMap = Collections.emptyMap();
    private @Nullable @UnknownKeyFor @Initialized PipelineOptions pipelineOptions;

    private JdbcConnection(@UnknownKeyFor @NonNull @Initialized CalciteConnection connection) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        super(connection);
    }

    static @UnknownKeyFor @NonNull @Initialized JdbcConnection initialize(@UnknownKeyFor @NonNull @Initialized CalciteConnection connection) {
        try {
            String currentSchemaName = (String)Preconditions.checkStateNotNull((Object)connection.getSchema(), (Object)"When trying to initialize JdbcConnection: No schema set.");
            JdbcConnection jdbcConnection = new JdbcConnection(connection);
            jdbcConnection.setPipelineOptionsMap(JdbcConnection.extractPipelineOptions(connection));
            jdbcConnection.setSchema(currentSchemaName, BeamCalciteSchemaFactory.catalogFromInitialEmptySchema(jdbcConnection));
            return jdbcConnection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> extractPipelineOptions(@UnknownKeyFor @NonNull @Initialized CalciteConnection calciteConnection) {
        return calciteConnection.getProperties().entrySet().stream().map(entry -> KV.of((Object)entry.getKey().toString(), (Object)entry.getValue().toString())).filter(kv -> ((String)kv.getKey()).startsWith(PIPELINE_OPTION_PREFIX)).map(kv -> KV.of((Object)((String)kv.getKey()).substring(PIPELINE_OPTION_PREFIX.length()), (Object)((String)kv.getValue()))).collect(Collectors.toMap(KV::getKey, KV::getValue));
    }

    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptionsMap() {
        return this.pipelineOptionsMap;
    }

    public void setPipelineOptionsMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptionsMap) {
        this.pipelineOptionsMap = ImmutableMap.copyOf(pipelineOptionsMap);
    }

    public void setPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public @Nullable @UnknownKeyFor @Initialized PipelineOptions getPipelineOptions() {
        return this.pipelineOptions;
    }

    @UnknownKeyFor @NonNull @Initialized Schema getCurrentBeamSchema() {
        return CalciteSchema.from((SchemaPlus)this.getCurrentSchemaPlus()).schema;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaPlus getCurrentSchemaPlus() {
        String currentSchema;
        try {
            currentSchema = (String)Preconditions.checkStateNotNull((Object)this.getSchema(), (Object)"Current schema not set");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return (SchemaPlus)Preconditions.checkStateNotNull((Object)this.getRootSchema().getSubSchema(currentSchema), (String)"SubSchema not found in `%s`: %s", (Object)this.getRootSchema().getName(), (Object)currentSchema);
    }

    void setSchema(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        BeamCalciteSchema beamCalciteSchema = new BeamCalciteSchema(name, this, tableProvider);
        this.getRootSchema().add(name, (Schema)beamCalciteSchema);
    }

    void setSchema(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        CatalogManagerSchema catalogManagerSchema = new CatalogManagerSchema(this, catalogManager);
        this.getRootSchema().add(name, (Schema)catalogManagerSchema);
    }
}

