/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogSchema
implements Schema {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CatalogSchema.class);
    private final @UnknownKeyFor @NonNull @Initialized JdbcConnection connection;
    private final @UnknownKeyFor @NonNull @Initialized Catalog catalog;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamCalciteSchema> subSchemas = new HashMap<String, BeamCalciteSchema>();

    CatalogSchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized Catalog catalog) {
        this.connection = jdbcConnection;
        this.catalog = catalog;
        this.subSchemas.put("default", new BeamCalciteSchema("default", this.connection, catalog.metaStore("default")));
    }

    public @UnknownKeyFor @NonNull @Initialized Catalog getCatalog() {
        return this.catalog;
    }

    public @Nullable @UnknownKeyFor @Initialized BeamCalciteSchema getCurrentDatabaseSchema() {
        return this.getSubSchema(this.catalog.currentDatabase());
    }

    public @UnknownKeyFor @NonNull @Initialized BeamCalciteSchema getDatabaseSchema(@UnknownKeyFor @NonNull @Initialized TableName tablePath) {
        @Nullable BeamCalciteSchema beamCalciteSchema = this.getSubSchema(tablePath.database());
        if (beamCalciteSchema == null) {
            beamCalciteSchema = this.getCurrentDatabaseSchema();
        }
        return (BeamCalciteSchema)Preconditions.checkStateNotNull((Object)beamCalciteSchema, (String)"Could not find BeamCalciteSchema for table: '%s'", (Object)tablePath);
    }

    public void createDatabase(@UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseIdentifier, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists) {
        String name = SqlDdlNodes.name(databaseIdentifier);
        boolean alreadyExists = this.subSchemas.containsKey(name);
        if (!alreadyExists || name.equals("default")) {
            try {
                LOG.info("Creating database '{}'", (Object)name);
                if (this.catalog.createDatabase(name)) {
                    LOG.info("Successfully created database '{}'", (Object)name);
                } else {
                    alreadyExists = true;
                }
            }
            catch (Exception e) {
                throw SqlUtil.newContextException((SqlParserPos)databaseIdentifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Encountered an error when creating database '%s': %s", name, e)));
            }
        }
        if (alreadyExists) {
            String message = String.format("Database '%s' already exists.", name);
            if (ifNotExists || name.equals("default")) {
                LOG.info(message);
            } else {
                throw SqlUtil.newContextException((SqlParserPos)databaseIdentifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(message));
            }
        }
        this.subSchemas.put(name, new BeamCalciteSchema(name, this.connection, this.catalog.metaStore(name)));
    }

    public void useDatabase(@UnknownKeyFor @NonNull @Initialized SqlIdentifier identifier) {
        String name = SqlDdlNodes.name(identifier);
        if (!this.subSchemas.containsKey(name)) {
            if (!this.catalog.databaseExists(name)) {
                throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Cannot use database: '%s' not found.", name)));
            }
            this.subSchemas.put(name, new BeamCalciteSchema(name, this.connection, this.catalog.metaStore(name)));
        }
        if (name.equals(this.catalog.currentDatabase())) {
            LOG.info("Database '{}' is already in use.", (Object)name);
            return;
        }
        this.catalog.useDatabase(name);
        LOG.info("Switched to database '{}'.", (Object)name);
    }

    public void dropDatabase(@UnknownKeyFor @NonNull @Initialized SqlIdentifier identifier, @UnknownKeyFor @NonNull @Initialized boolean cascade, @UnknownKeyFor @NonNull @Initialized boolean ifExists) {
        String name;
        block4: {
            name = SqlDdlNodes.name(identifier);
            try {
                LOG.info("Dropping database '{}'", (Object)name);
                boolean dropped = this.catalog.dropDatabase(name, cascade);
                if (dropped) {
                    LOG.info("Successfully dropped database '{}'", (Object)name);
                    break block4;
                }
                if (ifExists) {
                    LOG.info("Database '{}' does not exist.", (Object)name);
                    break block4;
                }
                throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Database '%s' does not exist.", name)));
            }
            catch (Exception e) {
                throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Encountered an error when dropping database '%s': %s", name, e)));
            }
        }
        this.subSchemas.remove(name);
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String s) {
        @Nullable BeamCalciteSchema beamCalciteSchema = this.currentDatabase();
        return beamCalciteSchema != null ? beamCalciteSchema.getTable(s) : null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        @Nullable BeamCalciteSchema beamCalciteSchema = this.currentDatabase();
        return beamCalciteSchema != null ? beamCalciteSchema.getTableNames() : Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized BeamCalciteSchema getSubSchema(@Nullable @UnknownKeyFor @Initialized String name) {
        if (name == null) {
            return null;
        }
        if (!this.subSchemas.containsKey(name) && this.catalog.databaseExists(name)) {
            this.subSchemas.put(name, new BeamCalciteSchema(name, this.connection, this.catalog.metaStore(name)));
        }
        return this.subSchemas.get(name);
    }

    private @Nullable @UnknownKeyFor @Initialized BeamCalciteSchema currentDatabase() {
        return this.getSubSchema(this.catalog.currentDatabase());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return this.subSchemas.keySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String s) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String s) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@Nullable @UnknownKeyFor @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized String s) {
        return Schemas.subSchemaExpression((SchemaPlus)((SchemaPlus)Preconditions.checkStateNotNull((Object)schemaPlus)), (String)s, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion schemaVersion) {
        return this;
    }
}

