/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.meta.SystemTables;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSystemTableMetadataSchema
implements Schema {
    private final @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;
    private final @MonotonicNonNull @UnknownKeyFor @Initialized String catalog;

    BeamSystemTableMetadataSchema(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager, @Nullable @UnknownKeyFor @Initialized String catalog) {
        this.catalogManager = catalogManager;
        this.catalog = catalog;
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String dbName) {
        if (this.catalog == null) {
            return null;
        }
        Catalog cat = (Catalog)Preconditions.checkArgumentNotNull((Object)this.catalogManager.getCatalog(this.catalog), (String)"Catalog '%s' does not exist.", (Object)this.catalog);
        if (dbName.equals("__current_database__")) {
            dbName = (String)Preconditions.checkStateNotNull((Object)cat.currentDatabase(), (Object)"Catalog '%s' has not set a default database. Please specify one.");
        }
        return BeamCalciteTable.of(SystemTables.tables(cat, dbName));
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getSubSchema(@Nullable @UnknownKeyFor @Initialized String catalogName) {
        if (this.catalog == null && catalogName != null) {
            if (catalogName.equals("__current_catalog__")) {
                catalogName = this.catalogManager.currentCatalog().name();
            }
            return new BeamSystemTableMetadataSchema(this.catalogManager, catalogName);
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String s) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String s) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@Nullable @UnknownKeyFor @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized String s) {
        return Schemas.subSchemaExpression((SchemaPlus)((SchemaPlus)Preconditions.checkStateNotNull((Object)schemaPlus)), (String)s, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion schemaVersion) {
        return this;
    }
}

