/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.BeamSystemDbMetadataSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamSystemTableMetadataSchema;
import org.apache.beam.sdk.extensions.sql.meta.SystemTables;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSystemSchema
implements Schema {
    private final @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;
    private final @UnknownKeyFor @NonNull @Initialized BeamSystemDbMetadataSchema dbSchema;
    private final @UnknownKeyFor @NonNull @Initialized BeamSystemTableMetadataSchema tableSchema;
    public static final @UnknownKeyFor @NonNull @Initialized String BEAMSYSTEM = "beamsystem";
    private static final @UnknownKeyFor @NonNull @Initialized String CATALOGS = "catalogs";
    private static final @UnknownKeyFor @NonNull @Initialized String DATABASES = "databases";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLES = "tables";

    BeamSystemSchema(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.dbSchema = new BeamSystemDbMetadataSchema(catalogManager);
        this.tableSchema = new BeamSystemTableMetadataSchema(catalogManager, null);
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String table) {
        switch (table) {
            case "catalogs": {
                return BeamCalciteTable.of(SystemTables.catalogs(this.catalogManager, false));
            }
            case "__current_catalog__": {
                return BeamCalciteTable.of(SystemTables.catalogs(this.catalogManager, true));
            }
            case "__current_database__": {
                return BeamCalciteTable.of(SystemTables.databases(this.catalogManager.currentCatalog(), true));
            }
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        return ImmutableSet.of((Object)CATALOGS);
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getSubSchema(@Nullable @UnknownKeyFor @Initialized String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "databases": {
                return this.dbSchema;
            }
            case "tables": {
                return this.tableSchema;
            }
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return ImmutableSet.of((Object)DATABASES, (Object)TABLES);
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String s) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String s) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@Nullable @UnknownKeyFor @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized String s) {
        return Schemas.subSchemaExpression((SchemaPlus)((SchemaPlus)Preconditions.checkStateNotNull((Object)schemaPlus)), (String)s, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion schemaVersion) {
        return this;
    }
}

