/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcDriver;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdfImpl;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.catalog.InMemoryCatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.UdfUdafProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.tools.RuleSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class BeamSqlEnv {
    @UnknownKeyFor @NonNull @Initialized JdbcConnection connection;
    @UnknownKeyFor @NonNull @Initialized QueryPlanner planner;

    private BeamSqlEnv(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized QueryPlanner planner) {
        this.connection = connection;
        this.planner = planner;
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder builder(@UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        return new BeamSqlEnvBuilder(tableProvider);
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder builder(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        return new BeamSqlEnvBuilder(catalogManager);
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamSqlEnv readOnly(@UnknownKeyFor @NonNull @Initialized String tableType, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamSqlTable> tables) {
        return BeamSqlEnv.withTableProvider(new ReadOnlyTableProvider(tableType, tables));
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamSqlEnv withTableProvider(@UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        return BeamSqlEnv.builder(tableProvider).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamSqlEnv inMemory(TableProvider ... tableProviders) {
        InMemoryCatalogManager catalogManager = new InMemoryCatalogManager();
        for (TableProvider tableProvider : tableProviders) {
            catalogManager.registerTableProvider(tableProvider);
        }
        return BeamSqlEnv.builder(catalogManager).setPipelineOptions(PipelineOptionsFactory.create()).build();
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode parseQuery(@UnknownKeyFor @NonNull @Initialized String query) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        return this.planner.convertToBeamRel(query, QueryPlanner.QueryParameters.ofNone());
    }

    public @UnknownKeyFor @NonNull @Initialized BeamRelNode parseQuery(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParameters) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        return this.planner.convertToBeamRel(query, queryParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDdl(@UnknownKeyFor @NonNull @Initialized String sqlStatement) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        return this.planner.parse(sqlStatement).getKind().belongsTo((Collection)SqlKind.DDL);
    }

    public void executeDdl(@UnknownKeyFor @NonNull @Initialized String sqlStatement) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        BeamSqlParser.DDL_EXECUTOR.executeDdl(this.getContext(), this.planner.parse(sqlStatement));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context getContext() {
        return this.connection.createPrepareContext();
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptions() {
        return this.connection.getPipelineOptionsMap();
    }

    public @UnknownKeyFor @NonNull @Initialized String explain(@UnknownKeyFor @NonNull @Initialized String sqlString) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        try {
            return RelOptUtil.toString((RelNode)this.planner.convertToBeamRel(sqlString, QueryPlanner.QueryParameters.ofNone()));
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse statement", e);
        }
    }

    public static class BeamSqlEnvBuilder {
        private static final @UnknownKeyFor @NonNull @Initialized String CALCITE_PLANNER = "org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner";
        private @UnknownKeyFor @NonNull @Initialized String queryPlannerClassName;
        private @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;
        private @Nullable @UnknownKeyFor @Initialized String currentSchemaName = null;
        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> schemaMap;
        private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function>> functionSet;
        private @UnknownKeyFor @NonNull @Initialized boolean autoLoadUdfs;
        private @Nullable @UnknownKeyFor @Initialized PipelineOptions pipelineOptions;
        private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets;

        private BeamSqlEnvBuilder(@UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
            if (tableProvider instanceof MetaStore) {
                this.catalogManager = new InMemoryCatalogManager((MetaStore)tableProvider);
            } else {
                this.catalogManager = new InMemoryCatalogManager();
                this.catalogManager.registerTableProvider(tableProvider);
            }
            this.queryPlannerClassName = CALCITE_PLANNER;
            this.schemaMap = new HashMap<String, TableProvider>();
            this.functionSet = new HashSet<Map.Entry<String, Function>>();
            this.autoLoadUdfs = false;
            this.pipelineOptions = null;
            this.ruleSets = BeamRuleSets.getRuleSets();
        }

        private BeamSqlEnvBuilder(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
            this.catalogManager = catalogManager;
            this.queryPlannerClassName = CALCITE_PLANNER;
            this.schemaMap = new HashMap<String, TableProvider>();
            this.functionSet = new HashSet<Map.Entry<String, Function>>();
            this.autoLoadUdfs = false;
            this.pipelineOptions = null;
            this.ruleSets = BeamRuleSets.getRuleSets();
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder addSchema(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
            if (this.schemaMap.containsKey(name)) {
                throw new RuntimeException("Schema " + name + " is registered twice.");
            }
            this.schemaMap.put(name, tableProvider);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder setCurrentSchema(@UnknownKeyFor @NonNull @Initialized String name) {
            this.currentSchemaName = name;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder setRuleSets(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
            this.ruleSets = ruleSets;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder addUdf(@UnknownKeyFor @NonNull @Initialized String functionName, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, @UnknownKeyFor @NonNull @Initialized String method) {
            this.functionSet.add(new AbstractMap.SimpleEntry<String, Function>(functionName, UdfImpl.create(clazz, method)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder addUdf(@UnknownKeyFor @NonNull @Initialized String functionName, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BeamSqlUdf> clazz) {
            return this.addUdf(functionName, clazz, "eval");
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder addUdf(@UnknownKeyFor @NonNull @Initialized String functionName, @UnknownKeyFor @NonNull @Initialized SerializableFunction sfn) {
            return this.addUdf(functionName, sfn.getClass(), "apply");
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder addUdaf(@UnknownKeyFor @NonNull @Initialized String functionName, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn combineFn) {
            this.functionSet.add(new AbstractMap.SimpleEntry(functionName, new UdafImpl(combineFn)));
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder autoLoadUserDefinedFunctions() {
            this.autoLoadUdfs = true;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder setQueryPlannerClassName(@UnknownKeyFor @NonNull @Initialized String name) {
            this.queryPlannerClassName = name;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder setPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            this.pipelineOptions = pipelineOptions;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnvBuilder setUseCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
            this.catalogManager.useCatalog(name);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamSqlEnv build() {
            Preconditions.checkStateNotNull((Object)this.pipelineOptions);
            JdbcConnection jdbcConnection = JdbcDriver.connect(this.catalogManager, this.pipelineOptions);
            this.configureSchemas(jdbcConnection);
            QueryPlanner planner = this.instantiatePlanner(jdbcConnection, this.ruleSets);
            this.loadUdfs();
            this.addUdfsUdafs(jdbcConnection);
            return new BeamSqlEnv(jdbcConnection, planner);
        }

        private void configureSchemas(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection) {
            this.schemaMap.forEach(jdbcConnection::setSchema);
            @Nullable String currentSchemaName = this.currentSchemaName;
            if (currentSchemaName == null || currentSchemaName.isEmpty()) {
                return;
            }
            try {
                jdbcConnection.setSchema(currentSchemaName);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private void loadUdfs() {
            if (!this.autoLoadUdfs) {
                return;
            }
            ServiceLoader.load(UdfUdafProvider.class).forEach(ins -> {
                ins.getBeamSqlUdfs().forEach(this::addUdf);
                ins.getSerializableFunctionUdfs().forEach(this::addUdf);
                ins.getUdafs().forEach(this::addUdaf);
            });
        }

        private void addUdfsUdafs(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection) {
            for (Map.Entry<String, Function> functionEntry : this.functionSet) {
                connection.getCurrentSchemaPlus().add(functionEntry.getKey(), functionEntry.getValue());
            }
        }

        private @UnknownKeyFor @NonNull @Initialized QueryPlanner instantiatePlanner(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
            QueryPlanner.Factory factory;
            Class<?> queryPlannerClass;
            try {
                queryPlannerClass = Class.forName(this.queryPlannerClassName);
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Cannot find requested QueryPlanner class: " + this.queryPlannerClassName, exc);
            }
            try {
                Object queryPlannerFactoryObj = Preconditions.checkStateNotNull((Object)queryPlannerClass.getField("FACTORY").get(null), (String)"Static field %s.FACTORY is null. It must be a QueryPlanner.Factory instance.", queryPlannerClass);
                factory = (QueryPlanner.Factory)queryPlannerFactoryObj;
            }
            catch (IllegalAccessException | NoSuchFieldException exc) {
                throw new RuntimeException(String.format("QueryPlanner class %s does not have an accessible static field 'FACTORY' of type QueryPlanner.Factory", this.queryPlannerClassName), exc);
            }
            return factory.createPlanner(jdbcConnection, ruleSets);
        }
    }
}

