/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class TestTableFilter
implements BeamSqlTableFilter {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> supported = new ArrayList<RexNode>();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> unsupported = new ArrayList<RexNode>();

    public TestTableFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> predicateCNF) {
        for (RexNode node : predicateCNF) {
            if (this.isSupported(node)) {
                this.supported.add(node);
                continue;
            }
            this.unsupported.add(node);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getNotSupported() {
        return this.unsupported;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int numSupported() {
        return BeamSqlTableFilter.expressionsInFilter(this.supported);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> getSupported() {
        return this.supported;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        String supStr = "supported{" + this.supported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        String unsupStr = "unsupported{" + this.unsupported.stream().map(RexNode::toString).collect(Collectors.joining()) + "}";
        return "[" + supStr + ", " + unsupStr + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @UnknownKeyFor @NonNull @Initialized boolean isSupported(@UnknownKeyFor @NonNull @Initialized RexNode node) {
        if (!node.getType().getSqlTypeName().equals((Object)SqlTypeName.BOOLEAN)) throw new UnsupportedOperationException("Predicate node '" + node.getClass().getSimpleName() + "' should be a boolean expression, but was: " + node.getType().getSqlTypeName());
        if (node instanceof RexCall) {
            RexCall compositeNode = (RexCall)node;
            if (!node.getKind().belongsTo((Collection)SqlKind.COMPARISON)) {
                return false;
            }
            if (node.getKind().equals((Object)SqlKind.IN)) {
                return false;
            }
            for (RexNode operand : compositeNode.getOperands()) {
                if (operand instanceof RexLiteral || operand instanceof RexInputRef) continue;
                return false;
            }
            return true;
        } else {
            if (!(node instanceof RexInputRef)) throw new UnsupportedOperationException("Encountered an unexpected node type: " + node.getClass().getSimpleName());
            return true;
        }
    }
}

