/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datagen;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamTableStatistics;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.datagen.DataGeneratorPTransform;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataGeneratorTable
extends SchemaBaseBeamTable {
    private final @UnknownKeyFor @NonNull @Initialized ObjectNode properties;

    public DataGeneratorTable(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized ObjectNode properties) {
        super(schema);
        this.properties = properties;
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return this.properties.has("number-of-rows") ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return (PCollection)begin.apply("ReadFromDataGenerator", (PTransform)new DataGeneratorPTransform(this.getSchema(), this.properties));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        return this.buildIOReader(begin);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        throw new UnsupportedOperationException("The 'datagen' table type is read-only.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamTableStatistics getTableStatistics(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        if (this.properties.has("number-of-rows")) {
            double rowCount = this.properties.get("number-of-rows").asDouble();
            return BeamTableStatistics.createBoundedTableStatistics(rowCount);
        }
        if (this.properties.has("rows-per-second")) {
            double rate = this.properties.get("rows-per-second").asDouble();
            return BeamTableStatistics.createUnboundedTableStatistics(rate);
        }
        return BeamTableStatistics.BOUNDED_UNKNOWN;
    }
}

