/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.impl.TVFSlidingWindowFn;
import org.apache.beam.sdk.extensions.sql.impl.ZetaSqlUserDefinedSQLNativeTableValuedFunction;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class BeamTableFunctionScanRel
extends TableFunctionScan
implements BeamRelNode {
    public BeamTableFunctionScanRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs, @UnknownKeyFor @NonNull @Initialized RexNode rexCall, @UnknownKeyFor @NonNull @Initialized Type elementType, @UnknownKeyFor @NonNull @Initialized RelDataType rowType, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RelColumnMapping> columnMappings) {
        super(cluster, traitSet, inputs, rexCall, elementType, rowType, columnMappings);
    }

    public @UnknownKeyFor @NonNull @Initialized TableFunctionScan copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> list, @UnknownKeyFor @NonNull @Initialized RexNode rexNode, @UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized RelDataType relDataType, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized RelColumnMapping> set) {
        return new BeamTableFunctionScanRel(this.getCluster(), traitSet, list, rexNode, type, relDataType, set);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    private @UnknownKeyFor @NonNull @Initialized Duration durationParameter(@UnknownKeyFor @NonNull @Initialized RexNode node) {
        return Duration.millis((long)this.longValue(node));
    }

    private @UnknownKeyFor @NonNull @Initialized long longValue(@UnknownKeyFor @NonNull @Initialized RexNode operand) {
        if (operand instanceof RexLiteral) {
            return ((Number)((Object)RexLiteral.value((RexNode)operand))).longValue();
        }
        throw new IllegalArgumentException(String.format("[%s] is not valid.", operand));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.getInput(0), mq);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputEstimates = BeamSqlRelUtils.getNodeStats(this.getInput(0), mq);
        double rowSize = this.getRowType().getFieldCount();
        double cpu = inputEstimates.getRowCount() * rowSize;
        double cpuRate = inputEstimates.getRate() * inputEstimates.getWindow() * rowSize;
        return BeamCostModel.FACTORY.makeCost(cpu, cpuRate);
    }

    private static class SessionWindowDoFn
    extends DoFn<KV<Row, Iterable<Row>>, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;

        public SessionWindowDoFn(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.outputSchema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> element, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
            IntervalWindow intervalWindow = (IntervalWindow)window;
            for (Row cur : (Iterable)element.getValue()) {
                Row.Builder builder = Row.withSchema((Schema)this.outputSchema).addValues(cur.getValues()).addValue((Object)intervalWindow.start()).addValue((Object)intervalWindow.end());
                out.output((Object)builder.build());
            }
        }
    }

    private static class SlidingWindowDoFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized int windowFieldIndex;
        private final @UnknownKeyFor @NonNull @Initialized SlidingWindows windowFn;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;

        public SlidingWindowDoFn(@UnknownKeyFor @NonNull @Initialized SlidingWindows windowFn, @UnknownKeyFor @NonNull @Initialized int windowFieldIndex, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.windowFn = windowFn;
            this.windowFieldIndex = windowFieldIndex;
            this.outputSchema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Row row = (Row)c.element();
            Collection windows = this.windowFn.assignWindows(row.getDateTime(this.windowFieldIndex).toInstant());
            for (IntervalWindow window : windows) {
                Row.Builder builder = Row.withSchema((Schema)this.outputSchema);
                builder.addValues(row.getValues());
                builder.addValue((Object)window.start());
                builder.addValue((Object)window.end());
                c.output((Object)builder.build());
            }
        }
    }

    private static class FixedWindowDoFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized int windowFieldIndex;
        private final @UnknownKeyFor @NonNull @Initialized FixedWindows windowFn;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;

        public FixedWindowDoFn(@UnknownKeyFor @NonNull @Initialized FixedWindows windowFn, @UnknownKeyFor @NonNull @Initialized int windowFieldIndex, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            this.windowFn = windowFn;
            this.windowFieldIndex = windowFieldIndex;
            this.outputSchema = schema;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Row row = (Row)c.element();
            IntervalWindow window = this.windowFn.assignWindow(row.getDateTime(this.windowFieldIndex).toInstant());
            Row.Builder builder = Row.withSchema((Schema)this.outputSchema);
            builder.addValues(row.getValues());
            builder.addValue((Object)window.start());
            builder.addValue((Object)window.end());
            c.output((Object)builder.build());
        }
    }

    private static class SessionKeyDoFn
    extends DoFn<Row, KV<Row, Row>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema keySchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> keyIndex;

        public SessionKeyDoFn(@UnknownKeyFor @NonNull @Initialized Schema keySchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> keyIndex) {
            this.keySchema = keySchema;
            this.keyIndex = keyIndex;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Row row = (Row)c.element();
            Row.Builder builder = Row.withSchema((Schema)this.keySchema);
            for (Integer i : this.keyIndex) {
                builder.addValue(row.getValue(i.intValue()));
            }
            Row keyRow = builder.build();
            c.output((Object)KV.of((Object)keyRow, (Object)row));
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private @UnknownKeyFor @NonNull @Initialized TVFToPTransform tumbleToPTransform = (call, upstream) -> {
            RexInputRef wmCol = (RexInputRef)call.getOperands().get(1);
            Schema outputSchema = CalciteUtils.toSchema(BeamTableFunctionScanRel.this.getRowType());
            FixedWindows windowFn = FixedWindows.of((Duration)BeamTableFunctionScanRel.this.durationParameter((RexNode)call.getOperands().get(2)));
            PCollection streamWithWindowMetadata = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new FixedWindowDoFn(windowFn, wmCol.getIndex(), outputSchema)))).setRowSchema(outputSchema);
            PCollection<Row> windowedStream = this.assignTimestampsAndWindow((PCollection<Row>)streamWithWindowMetadata, wmCol.getIndex(), (WindowFn<Row, IntervalWindow>)windowFn);
            return windowedStream;
        };
        private @UnknownKeyFor @NonNull @Initialized TVFToPTransform hopToPTransform = (call, upstream) -> {
            RexInputRef wmCol = (RexInputRef)call.getOperands().get(1);
            Schema outputSchema = CalciteUtils.toSchema(BeamTableFunctionScanRel.this.getRowType());
            Duration period = BeamTableFunctionScanRel.this.durationParameter((RexNode)call.getOperands().get(2));
            Duration size = BeamTableFunctionScanRel.this.durationParameter((RexNode)call.getOperands().get(3));
            SlidingWindows windowFn = SlidingWindows.of((Duration)size).every(period);
            PCollection streamWithWindowMetadata = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new SlidingWindowDoFn(windowFn, wmCol.getIndex(), outputSchema)))).setRowSchema(outputSchema);
            TVFSlidingWindowFn specialWindowFn = TVFSlidingWindowFn.of(size, period);
            PCollection<Row> windowedStream = this.assignTimestampsAndWindow((PCollection<Row>)streamWithWindowMetadata, wmCol.getIndex(), (WindowFn<Row, IntervalWindow>)specialWindowFn);
            return windowedStream;
        };
        private @UnknownKeyFor @NonNull @Initialized TVFToPTransform sessionToPTransform = (call, upstream) -> {
            RexInputRef wmCol = (RexInputRef)call.getOperands().get(1);
            Duration gap = BeamTableFunctionScanRel.this.durationParameter((RexNode)call.getOperands().get(2));
            ArrayList<Integer> keyIndex = new ArrayList<Integer>();
            for (RexNode node : call.getOperands().subList(3, call.getOperands().size())) {
                keyIndex.add(((RexInputRef)node).getIndex());
            }
            Sessions sessions = Sessions.withGapDuration((Duration)gap);
            PCollection<Row> windowedStream = this.assignTimestampsAndWindow((PCollection<Row>)upstream, wmCol.getIndex(), (WindowFn<Row, IntervalWindow>)sessions);
            Schema inputSchema = upstream.getSchema();
            Schema keySchema = this.getKeySchema(inputSchema, keyIndex);
            Schema outputSchema = CalciteUtils.toSchema(BeamTableFunctionScanRel.this.getRowType());
            PCollection streamWithWindowMetadata = ((PCollection)((PCollection)((PCollection)windowedStream.apply("assign_session_key", (PTransform)ParDo.of((DoFn)new SessionKeyDoFn(keySchema, keyIndex)))).setCoder((Coder)KvCoder.of((Coder)RowCoder.of((Schema)keySchema), (Coder)upstream.getCoder())).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new SessionWindowDoFn(outputSchema)))).setRowSchema(outputSchema);
            PCollection reWindowedStream = (PCollection)streamWithWindowMetadata.apply("reWindowIntoGlobalWindow", (PTransform)Window.into((WindowFn)new GlobalWindows()));
            return reWindowedStream;
        };
        private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TVFToPTransform> tvfToPTransformMap = ImmutableMap.of((Object)"TUMBLE", (Object)this.tumbleToPTransform, (Object)"HOP", (Object)this.hopToPTransform, (Object)"SESSION", (Object)this.sessionToPTransform);

        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> input) {
            Preconditions.checkArgument((input.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s, expected 1 input but received: %s", (Object)BeamTableFunctionScanRel.class.getSimpleName(), input);
            String operatorName = ((RexCall)BeamTableFunctionScanRel.this.getCall()).getOperator().getName();
            if (this.tvfToPTransformMap.keySet().contains((Object)operatorName)) {
                return ((TVFToPTransform)this.tvfToPTransformMap.get((Object)operatorName)).toPTransform((RexCall)BeamTableFunctionScanRel.this.getCall(), (PCollection<Row>)input.get(0));
            }
            if (((RexCall)BeamTableFunctionScanRel.this.getCall()).getOperator() instanceof ZetaSqlUserDefinedSQLNativeTableValuedFunction) {
                return input.get(0);
            }
            throw new IllegalArgumentException(String.format("Does not support table_valued function: %s", operatorName));
        }

        private @UnknownKeyFor @NonNull @Initialized Schema getKeySchema(@UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> keys) {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            for (Integer i : keys) {
                fields.add(inputSchema.getField(i.intValue()));
            }
            return Schema.builder().addFields(fields).build();
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> assignTimestampsAndWindow(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> upstream, @UnknownKeyFor @NonNull @Initialized int windowFieldIndex, @UnknownKeyFor @NonNull @Initialized WindowFn<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized IntervalWindow> windowFn) {
            PCollection windowedStream = (PCollection)((PCollection)upstream.apply("assignEventTimestamp", (PTransform)WithTimestamps.of((SerializableFunction & Serializable)row -> row.getDateTime(windowFieldIndex).toInstant()).withAllowedTimestampSkew(Duration.millis((long)Long.MAX_VALUE)))).setCoder(upstream.getCoder()).apply((PTransform)Window.into(windowFn));
            return windowedStream;
        }
    }

    private static interface TVFToPTransform {
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> toPTransform(@UnknownKeyFor @NonNull @Initialized RexCall var1, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> var2);
    }
}

