/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSetOption;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class SqlUseDatabase
extends SqlSetOption
implements BeamSqlParser.ExecutableStatement {
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("USE DATABASE", SqlKind.OTHER);

    public SqlUseDatabase(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized String scope, @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName) {
        super(pos, scope, SqlDdlNodes.getIdentifier((SqlNode)databaseName, pos), null);
        this.databaseName = databaseName;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized SqlOperator getOperator() {
        return OPERATOR;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return Collections.singletonList(this.databaseName);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.databaseName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        String path = this.databaseName.toString();
        ArrayList components = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)path));
        TableName pathOverride = TableName.create(components, "");
        if (!(schema instanceof CatalogManagerSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to create database '" + path + "' with unexpected Calcite Schema of type " + schema.getClass()));
        }
        CatalogManagerSchema catalogManagerSchema = (CatalogManagerSchema)schema;
        CatalogSchema catalogSchema = catalogManagerSchema.getCatalogSchema(pathOverride);
        if (pathOverride.catalog() != null && !pathOverride.catalog().equals(catalogManagerSchema.getCurrentCatalogSchema().getCatalog().name())) {
            SqlIdentifier catalogIdentifier = new SqlIdentifier(pathOverride.catalog(), this.databaseName.getParserPosition());
            catalogManagerSchema.useCatalog(catalogIdentifier);
        }
        catalogSchema.useDatabase(this.databaseName);
    }
}

