/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.catalog;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryCatalog
implements Catalog {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties;
    private final @UnknownKeyFor @NonNull @Initialized InMemoryMetaStore metaStore = new InMemoryMetaStore();
    private final @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> databases = new HashSet<String>(Collections.singleton("default"));
    protected @Nullable @UnknownKeyFor @Initialized String currentDatabase = "default";

    public InMemoryCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        this.name = name;
        this.properties = properties;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String type() {
        return "local";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String name() {
        return (String)Preconditions.checkStateNotNull((Object)this.name, (Object)(this.getClass().getSimpleName() + " has not been initialized"));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetaStore metaStore() {
        return this.metaStore;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties() {
        return (Map)Preconditions.checkStateNotNull(this.properties, (Object)"InMemoryCatalog has not been initialized");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean createDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
        return this.databases.add(database);
    }

    @Override
    public void useDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.listDatabases().contains(database), (Object)"Database '%s' does not exist.");
        this.currentDatabase = database;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String currentDatabase() {
        return this.currentDatabase;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean dropDatabase(@UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized boolean cascade) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!cascade ? 1 : 0) != 0, (Object)(this.getClass().getSimpleName() + " does not support CASCADE."));
        boolean removed = this.databases.remove(database);
        if (database.equals(this.currentDatabase)) {
            this.currentDatabase = null;
        }
        return removed;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> listDatabases() {
        return this.databases;
    }
}

