/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteTable;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamCalciteSchema
implements Schema {
    private @UnknownKeyFor @NonNull @Initialized JdbcConnection connection;
    private @Nullable @UnknownKeyFor @Initialized TableProvider tableProvider;
    private @Nullable @UnknownKeyFor @Initialized CatalogManager catalogManager;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BeamCalciteSchema> subSchemas;

    BeamCalciteSchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        this.connection = jdbcConnection;
        this.tableProvider = tableProvider;
        this.subSchemas = new HashMap<String, BeamCalciteSchema>();
    }

    BeamCalciteSchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        this.connection = jdbcConnection;
        this.catalogManager = catalogManager;
        this.subSchemas = new HashMap<String, BeamCalciteSchema>();
    }

    public @UnknownKeyFor @NonNull @Initialized TableProvider getTableProvider() {
        return this.resolveMetastore();
    }

    public @Nullable @UnknownKeyFor @Initialized CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptions() {
        return this.connection.getPipelineOptionsMap();
    }

    public void setPipelineOption(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String value) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.put(key, value);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removePipelineOption(@UnknownKeyFor @NonNull @Initialized String key) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.remove(key);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removeAllPipelineOptions() {
        this.connection.setPipelineOptionsMap(Collections.emptyMap());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@UnknownKeyFor @NonNull @Initialized SchemaPlus parentSchema, @UnknownKeyFor @NonNull @Initialized String name) {
        return Schemas.subSchemaExpression((SchemaPlus)parentSchema, (String)name, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        return this.resolveMetastore().getTables().keySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String name) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table getTable(@UnknownKeyFor @NonNull @Initialized String name) {
        Table table = this.resolveMetastore().getTable(name);
        if (table == null) {
            return null;
        }
        return new BeamCalciteTable(this.resolveMetastore().buildBeamSqlTable(table), this.getPipelineOptions(), this.connection.getPipelineOptions());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String name) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return this.resolveMetastore().getSubProviders();
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSubSchema(@UnknownKeyFor @NonNull @Initialized String name) {
        if (!this.subSchemas.containsKey(name)) {
            Catalog catalog;
            TableProvider subProvider;
            BeamCalciteSchema subSchema = this.tableProvider != null ? ((subProvider = this.tableProvider.getSubProvider(name)) != null ? new BeamCalciteSchema(this.connection, subProvider) : null) : ((catalog = ((CatalogManager)Preconditions.checkStateNotNull((Object)this.catalogManager)).getCatalog(name)) != null ? new BeamCalciteSchema(this.connection, catalog.metaStore()) : null);
            this.subSchemas.put(name, subSchema);
        }
        return this.subSchemas.get(name);
    }

    public @UnknownKeyFor @NonNull @Initialized TableProvider resolveMetastore() {
        if (this.tableProvider != null) {
            return this.tableProvider;
        }
        return ((CatalogManager)Preconditions.checkStateNotNull((Object)this.catalogManager)).currentCatalog().metaStore();
    }
}

