/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.JdbcFactory;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.AvaticaFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.Driver;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.rules.CoreRules;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Hook;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={java.sql.Driver.class})
public class JdbcDriver
extends Driver {
    public static final @UnknownKeyFor @NonNull @Initialized JdbcDriver INSTANCE = new JdbcDriver();
    public static final @UnknownKeyFor @NonNull @Initialized String CONNECT_STRING_PREFIX = "jdbc:beam:";
    static final @UnknownKeyFor @NonNull @Initialized String TOP_LEVEL_BEAM_SCHEMA = "beam";

    protected @UnknownKeyFor @NonNull @Initialized AvaticaFactory createFactory() {
        return JdbcFactory.wrap((CalciteFactory)super.createFactory());
    }

    protected @UnknownKeyFor @NonNull @Initialized String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public @UnknownKeyFor @NonNull @Initialized Connection connect(@UnknownKeyFor @NonNull @Initialized String url, @UnknownKeyFor @NonNull @Initialized Properties info) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        return JdbcConnection.initialize((CalciteConnection)super.connect(url, info));
    }

    public static @UnknownKeyFor @NonNull @Initialized JdbcConnection connect(@UnknownKeyFor @NonNull @Initialized TableProvider tableProvider, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        JdbcConnection connection = JdbcDriver.getConnection(options);
        connection.setSchema(TOP_LEVEL_BEAM_SCHEMA, tableProvider);
        return connection;
    }

    public static @UnknownKeyFor @NonNull @Initialized JdbcConnection connect(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        JdbcConnection connection = JdbcDriver.getConnection(options);
        connection.setSchema(TOP_LEVEL_BEAM_SCHEMA, catalogManager);
        return connection;
    }

    private static @UnknownKeyFor @NonNull @Initialized JdbcConnection getConnection(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        JdbcConnection connection;
        Map<String, String> calciteConnectionProperties;
        Properties properties = new Properties();
        properties.setProperty(CalciteConnectionProperty.SCHEMA_FACTORY.camelName(), BeamCalciteSchemaFactory.Empty.class.getName());
        BeamSqlPipelineOptions sqlOptions = (BeamSqlPipelineOptions)options.as(BeamSqlPipelineOptions.class);
        if (sqlOptions != null && (calciteConnectionProperties = sqlOptions.getCalciteConnectionProperties()) != null) {
            properties.putAll(calciteConnectionProperties);
        }
        try {
            connection = (JdbcConnection)((Object)INSTANCE.connect(CONNECT_STRING_PREFIX, properties));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        connection.setPipelineOptions(options);
        return connection;
    }

    static {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JdbcDriver.class.getClassLoader());
            CompilerFactoryFactory.getDefaultCompilerFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
        Hook.PLANNER.add(planner -> {
            for (RuleSet ruleSet : BeamRuleSets.getRuleSets()) {
                for (RelOptRule rule : ruleSet) {
                    planner.addRule(rule);
                }
            }
            planner.removeRule((RelOptRule)CoreRules.CALC_REMOVE);
            planner.removeRule((RelOptRule)CoreRules.SORT_REMOVE);
            for (RelOptRule rule : EnumerableRules.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
            ArrayList relTraitDefs = new ArrayList(planner.getRelTraitDefs());
            planner.clearRelTraitDefs();
            for (RelTraitDef def : relTraitDefs) {
                if (def instanceof RelCollationTraitDef) continue;
                planner.addRelTraitDef(def);
            }
        });
        INSTANCE.register();
    }
}

