/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.JavaUdfLoader;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamJavaTypeFactory;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.schemas.logicaltypes.FixedString;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableBytes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableString;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.DataContext;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Node;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPredicateList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexSimplify;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlConformance;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamCalcRel
extends AbstractBeamCalcRel {
    private static final @UnknownKeyFor @NonNull @Initialized long NANOS_PER_MILLISECOND = 1000000L;
    private static final @UnknownKeyFor @NonNull @Initialized long MILLIS_PER_DAY = 86400000L;
    private static final @UnknownKeyFor @NonNull @Initialized ParameterExpression rowParam = Expressions.parameter(Row.class, (String)"row");
    private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> rows = new TupleTag<Row>(){};
    private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> errors = new TupleTag<Row>(){};
    private static final @UnknownKeyFor @NonNull @Initialized DataContext CONTEXT_INSTANCE = new SlimDataContext();

    public BeamCalcRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        super(cluster, traits, input, program);
    }

    public @UnknownKeyFor @NonNull @Initialized Calc copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        return new BeamCalcRel(this.getCluster(), traitSet, input, program);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform(@Nullable @UnknownKeyFor @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorsTransformer) {
        return new Transform(errorsTransformer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform(null);
    }

    private @UnknownKeyFor @NonNull @Initialized RowCoder getErrorRowCoder(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> upstream, @UnknownKeyFor @NonNull @Initialized InputGetterImpl inputGetter) {
        return RowCoder.of((Schema)BeamSqlRelUtils.getErrorRowSchema(SelectHelpers.getOutputSchema((Schema)upstream.getSchema(), (FieldAccessDescriptor)inputGetter.getFieldAccess())));
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getJarPaths(@UnknownKeyFor @NonNull @Initialized RexProgram program) {
        ImmutableList.Builder jarPaths = new ImmutableList.Builder();
        for (RexNode node : program.getExprList()) {
            String jarPath;
            Function function;
            SqlOperator op;
            if (!(node instanceof RexCall) || !((op = ((RexCall)node).op) instanceof SqlUserDefinedFunction) || !((function = ((SqlUserDefinedFunction)op).function) instanceof ScalarFunctionImpl) || (jarPath = ((ScalarFunctionImpl)function).getJarPath()).isEmpty()) continue;
            jarPaths.add((Object)jarPath);
        }
        return jarPaths.build();
    }

    static @UnknownKeyFor @NonNull @Initialized Object toBeamObject(@UnknownKeyFor @NonNull @Initialized Object value, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        if (value == null) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case INT16: {
                return ((Number)value).shortValue();
            }
            case INT32: {
                return ((Number)value).intValue();
            }
            case INT64: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case DECIMAL: {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)value;
                }
                if (value instanceof Long) {
                    return BigDecimal.valueOf((Long)value);
                }
                if (value instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)value).intValue());
                }
                return new BigDecimal(((Number)value).toString());
            }
            case STRING: {
                return (String)value;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case DATETIME: {
                if (value instanceof Timestamp) {
                    value = SqlFunctions.toLong((Timestamp)((Timestamp)value));
                }
                return Instant.ofEpochMilli((long)((Number)value).longValue());
            }
            case BYTES: {
                if (value instanceof byte[]) {
                    return value;
                }
                return ((ByteString)value).getBytes();
            }
            case ARRAY: 
            case ITERABLE: {
                return BeamCalcRel.toBeamList((List)value, fieldType.getCollectionElementType(), verifyValues);
            }
            case MAP: {
                return BeamCalcRel.toBeamMap((Map)value, fieldType.getMapKeyType(), fieldType.getMapValueType(), verifyValues);
            }
            case ROW: {
                if (value instanceof Object[]) {
                    value = Arrays.asList((Object[])value);
                }
                return BeamCalcRel.toBeamRow((List)value, fieldType.getRowSchema(), verifyValues);
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                assert (logicalType != null);
                String identifier = logicalType.getIdentifier();
                if ("SqlTimeWithLocalTzType".equals(identifier)) {
                    return Instant.ofEpochMilli((long)((Number)value).longValue());
                }
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    if (value instanceof java.sql.Date) {
                        value = SqlFunctions.toInt((Date)((java.sql.Date)value));
                    }
                    return LocalDate.ofEpochDay(((Number)value).longValue());
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    if (value instanceof Time) {
                        value = SqlFunctions.toInt((Time)((Time)value));
                    }
                    return LocalTime.ofNanoOfDay(((Number)value).longValue() * 1000000L);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    if (value instanceof Timestamp) {
                        value = SqlFunctions.toLong((Timestamp)((Timestamp)value));
                    }
                    return LocalDateTime.of(LocalDate.ofEpochDay(((Number)value).longValue() / 86400000L), LocalTime.ofNanoOfDay(((Number)value).longValue() % 86400000L * 1000000L));
                }
                if (logicalType instanceof PassThroughLogicalType) {
                    return BeamCalcRel.toBeamObject(value, logicalType.getBaseType(), verifyValues);
                }
                throw new UnsupportedOperationException("Unable to convert logical type " + identifier);
            }
        }
        throw new UnsupportedOperationException("Unable to convert " + fieldType.getTypeName());
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> toBeamList(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> arrayValue, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        return arrayValue.stream().map(e -> BeamCalcRel.toBeamObject(e, elementType, verifyValues)).collect(Collectors.toList());
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> toBeamMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> mapValue, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType keyType, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        HashMap<Object, Object> output = new HashMap<Object, Object>(mapValue.size());
        for (Map.Entry<Object, Object> entry : mapValue.entrySet()) {
            output.put(BeamCalcRel.toBeamObject(entry.getKey(), keyType, verifyValues), BeamCalcRel.toBeamObject(entry.getValue(), elementType, verifyValues));
        }
        return output;
    }

    private static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> structValue, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized boolean verifyValues) {
        ArrayList<Object> objects = new ArrayList<Object>(schema.getFieldCount());
        assert (structValue.size() == schema.getFieldCount());
        for (int i = 0; i < structValue.size(); ++i) {
            objects.add(BeamCalcRel.toBeamObject(structValue.get(i), schema.getField(i).getType(), verifyValues));
        }
        Row row = verifyValues ? Row.withSchema((Schema)schema).addValues(objects).build() : Row.withSchema((Schema)schema).attachValues(objects);
        return row;
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression nullOr(@UnknownKeyFor @NonNull @Initialized Expression field, @UnknownKeyFor @NonNull @Initialized Expression ifNotNull) {
        return Expressions.condition((Expression)Expressions.equal((Expression)field, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.box((Expression)ifNotNull));
    }

    public static abstract class WrappedList<@UnknownKeyFor T>
    extends AbstractList<T> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values;

        protected WrappedList(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values) {
            this.values = values;
        }

        @Override
        @Pure
        public T get(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.value(this.values.get(index));
        }

        protected abstract T value(@UnknownKeyFor @NonNull @Initialized Object var1);

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int size() {
            return this.values.size();
        }
    }

    public static abstract class WrappedMap<@UnknownKeyFor V>
    extends AbstractMap<Object, V> {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> map;

        protected WrappedMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> map) {
            this.map = map;
        }

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized Object, V>> entrySet() {
            return Maps.transformValues(this.map, val -> val == null ? null : this.value(val)).entrySet();
        }

        @Override
        @Pure
        public V get(@UnknownKeyFor @NonNull @Initialized Object key) {
            return this.value(this.map.get(key));
        }

        protected abstract V value(@UnknownKeyFor @NonNull @Initialized Object var1);
    }

    public static abstract class WrappedRow
    extends AbstractList<Object> {
        private final @UnknownKeyFor @NonNull @Initialized Row row;

        protected WrappedRow(@UnknownKeyFor @NonNull @Initialized Row row) {
            this.row = row;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized int index) {
            return this.field(this.row, index);
        }

        protected abstract @UnknownKeyFor @NonNull @Initialized Object field(@UnknownKeyFor @NonNull @Initialized Row var1, @UnknownKeyFor @NonNull @Initialized int var2);

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized int size() {
            return this.row.getFieldCount();
        }
    }

    private static class SlimDataContext
    implements DataContext {
        private SlimDataContext() {
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaPlus getRootSchema() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized JavaTypeFactory getTypeFactory() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized QueryProvider getQueryProvider() {
            return null;
        }

        public @UnknownKeyFor @NonNull @Initialized Object get(@UnknownKeyFor @NonNull @Initialized String name) {
            if (name.equals(DataContext.Variable.UTC_TIMESTAMP.camelName) || name.equals(DataContext.Variable.CURRENT_TIMESTAMP.camelName) || name.equals(DataContext.Variable.LOCAL_TIMESTAMP.camelName)) {
                return System.currentTimeMillis();
            }
            if (name.equals(DataContext.Variable.TIME_ZONE.camelName)) {
                return TimeZone.getDefault();
            }
            return null;
        }
    }

    private static class InputGetterImpl
    implements RexToLixTranslator.InputGetter {
        private final @UnknownKeyFor @NonNull @Initialized Expression input;
        private final @UnknownKeyFor @NonNull @Initialized Schema inputSchema;
        private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Integer> referencedColumns;

        private InputGetterImpl(@UnknownKeyFor @NonNull @Initialized Expression input, @UnknownKeyFor @NonNull @Initialized Schema inputSchema) {
            this.input = input;
            this.inputSchema = inputSchema;
            this.referencedColumns = new TreeSet<Integer>();
        }

        @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccess() {
            return FieldAccessDescriptor.withFieldIds(this.referencedColumns);
        }

        public @UnknownKeyFor @NonNull @Initialized Expression field(@UnknownKeyFor @NonNull @Initialized BlockBuilder list, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Type storageType) {
            this.referencedColumns.add(index);
            return InputGetterImpl.getBeamField(list, index, this.input, this.inputSchema);
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression getBeamField(@UnknownKeyFor @NonNull @Initialized BlockBuilder list, @UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized Expression input, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            MethodCallExpression value;
            if (index >= schema.getFieldCount() || index < 0) {
                throw new IllegalArgumentException("Unable to find value #" + index);
            }
            Expression expression = list.append(list.newName("current"), input);
            Schema.Field field = schema.getField(index);
            Schema.FieldType fieldType = field.getType();
            ConstantExpression fieldName = Expressions.constant((Object)field.getName());
            switch (fieldType.getTypeName()) {
                case BYTE: {
                    value = Expressions.call((Expression)expression, (String)"getByte", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case INT16: {
                    value = Expressions.call((Expression)expression, (String)"getInt16", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case INT32: {
                    value = Expressions.call((Expression)expression, (String)"getInt32", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case INT64: {
                    value = Expressions.call((Expression)expression, (String)"getInt64", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case DECIMAL: {
                    value = Expressions.call((Expression)expression, (String)"getDecimal", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case FLOAT: {
                    value = Expressions.call((Expression)expression, (String)"getFloat", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case DOUBLE: {
                    value = Expressions.call((Expression)expression, (String)"getDouble", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case STRING: {
                    value = Expressions.call((Expression)expression, (String)"getString", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case DATETIME: {
                    value = Expressions.call((Expression)expression, (String)"getDateTime", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case BOOLEAN: {
                    value = Expressions.call((Expression)expression, (String)"getBoolean", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case BYTES: {
                    value = Expressions.call((Expression)expression, (String)"getBytes", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case ARRAY: {
                    value = Expressions.call((Expression)expression, (String)"getArray", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case MAP: {
                    value = Expressions.call((Expression)expression, (String)"getMap", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case ROW: {
                    value = Expressions.call((Expression)expression, (String)"getRow", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case ITERABLE: {
                    value = Expressions.call((Expression)expression, (String)"getIterable", (Expression[])new Expression[]{fieldName});
                    break;
                }
                case LOGICAL_TYPE: {
                    String identifier = fieldType.getLogicalType().getIdentifier();
                    if (FixedString.IDENTIFIER.equals(identifier) || VariableString.IDENTIFIER.equals(identifier)) {
                        value = Expressions.call((Expression)expression, (String)"getString", (Expression[])new Expression[]{fieldName});
                        break;
                    }
                    if (FixedBytes.IDENTIFIER.equals(identifier) || VariableBytes.IDENTIFIER.equals(identifier)) {
                        value = Expressions.call((Expression)expression, (String)"getBytes", (Expression[])new Expression[]{fieldName});
                        break;
                    }
                    if ("SqlTimeWithLocalTzType".equals(identifier)) {
                        value = Expressions.call((Expression)expression, (String)"getDateTime", (Expression[])new Expression[]{fieldName});
                        break;
                    }
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{fieldName, Expressions.constant(LocalDate.class)}), LocalDate.class);
                        break;
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{fieldName, Expressions.constant(LocalTime.class)}), LocalTime.class);
                        break;
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)Expressions.call((Expression)expression, (String)"getLogicalTypeValue", (Expression[])new Expression[]{fieldName, Expressions.constant(LocalDateTime.class)}), LocalDateTime.class);
                        break;
                    }
                    throw new UnsupportedOperationException("Unable to get logical type " + identifier);
                }
                default: {
                    throw new UnsupportedOperationException("Unable to get " + fieldType.getTypeName());
                }
            }
            return InputGetterImpl.toCalciteValue((Expression)value, fieldType);
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression toCalciteValue(@UnknownKeyFor @NonNull @Initialized Expression value, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
            switch (fieldType.getTypeName()) {
                case BYTE: {
                    return Expressions.convert_((Expression)value, Byte.class);
                }
                case INT16: {
                    return Expressions.convert_((Expression)value, Short.class);
                }
                case INT32: {
                    return Expressions.convert_((Expression)value, Integer.class);
                }
                case INT64: {
                    return Expressions.convert_((Expression)value, Long.class);
                }
                case DECIMAL: {
                    return Expressions.convert_((Expression)value, BigDecimal.class);
                }
                case FLOAT: {
                    return Expressions.convert_((Expression)value, Float.class);
                }
                case DOUBLE: {
                    return Expressions.convert_((Expression)value, Double.class);
                }
                case STRING: {
                    return Expressions.convert_((Expression)value, String.class);
                }
                case BOOLEAN: {
                    return Expressions.convert_((Expression)value, Boolean.class);
                }
                case DATETIME: {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, DateTime.class), (String)"getMillis", (Expression[])new Expression[0]));
                }
                case BYTES: {
                    return BeamCalcRel.nullOr(value, (Expression)Expressions.new_(ByteString.class, (Expression[])new Expression[]{Expressions.convert_((Expression)value, byte[].class)}));
                }
                case ARRAY: 
                case ITERABLE: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteList(value, fieldType.getCollectionElementType()));
                }
                case MAP: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteMap(value, fieldType.getMapValueType()));
                }
                case ROW: {
                    return BeamCalcRel.nullOr(value, InputGetterImpl.toCalciteRow(value, fieldType.getRowSchema()));
                }
                case LOGICAL_TYPE: {
                    String identifier = fieldType.getLogicalType().getIdentifier();
                    if (FixedString.IDENTIFIER.equals(identifier) || VariableString.IDENTIFIER.equals(identifier)) {
                        return Expressions.convert_((Expression)value, String.class);
                    }
                    if (FixedBytes.IDENTIFIER.equals(identifier) || VariableBytes.IDENTIFIER.equals(identifier)) {
                        return Expressions.convert_((Expression)value, byte[].class);
                    }
                    if ("SqlTimeWithLocalTzType".equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, DateTime.class), (String)"getMillis", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.box((Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, LocalDate.class), (String)"toEpochDay", (Expression[])new Expression[0])), (String)"intValue", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                        return BeamCalcRel.nullOr(value, (Expression)Expressions.call((Expression)Expressions.box((Expression)Expressions.divide((Expression)Expressions.call((Expression)Expressions.convert_((Expression)value, LocalTime.class), (String)"toNanoOfDay", (Expression[])new Expression[0]), (Expression)Expressions.constant((Object)1000000L))), (String)"intValue", (Expression[])new Expression[0]));
                    }
                    if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                        value = Expressions.convert_((Expression)value, LocalDateTime.class);
                        MethodCallExpression dateValue = Expressions.call((Expression)Expressions.call((Expression)value, (String)"toLocalDate", (Expression[])new Expression[0]), (String)"toEpochDay", (Expression[])new Expression[0]);
                        MethodCallExpression timeValue = Expressions.call((Expression)Expressions.call((Expression)value, (String)"toLocalTime", (Expression[])new Expression[0]), (String)"toNanoOfDay", (Expression[])new Expression[0]);
                        BinaryExpression returnValue = Expressions.add((Expression)Expressions.multiply((Expression)dateValue, (Expression)Expressions.constant((Object)86400000L)), (Expression)Expressions.divide((Expression)timeValue, (Expression)Expressions.constant((Object)1000000L)));
                        return BeamCalcRel.nullOr(value, (Expression)returnValue);
                    }
                    throw new UnsupportedOperationException("Unable to convert logical type " + identifier);
                }
            }
            throw new UnsupportedOperationException("Unable to convert " + fieldType.getTypeName());
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression toCalciteList(@UnknownKeyFor @NonNull @Initialized Expression input, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType elementType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.toCalciteValue((Expression)value, elementType));
            return Expressions.new_(WrappedList.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(List.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression toCalciteMap(@UnknownKeyFor @NonNull @Initialized Expression input, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType mapValueType) {
            ParameterExpression value = Expressions.parameter(Object.class);
            BlockBuilder block = new BlockBuilder();
            block.add(InputGetterImpl.toCalciteValue((Expression)value, mapValueType));
            return Expressions.new_(WrappedMap.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Map.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"value", (Iterable)ImmutableList.of((Object)value), (BlockStatement)block.toBlock())));
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression toCalciteRow(@UnknownKeyFor @NonNull @Initialized Expression input, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            ParameterExpression row = Expressions.parameter(Row.class);
            ParameterExpression index = Expressions.parameter(Integer.TYPE);
            BlockBuilder body = new BlockBuilder(false);
            for (int i = 0; i < schema.getFieldCount(); ++i) {
                BlockBuilder list = new BlockBuilder(false, body);
                Expression returnValue = InputGetterImpl.getBeamField(list, i, (Expression)row, schema);
                list.append(returnValue);
                body.add((Statement)Expressions.ifThen((Expression)Expressions.equal((Expression)index, (Expression)Expressions.constant((Object)i, Integer.TYPE)), (Node)list.toBlock()));
            }
            body.add((Statement)Expressions.throw_((Expression)Expressions.new_(IndexOutOfBoundsException.class)));
            return Expressions.new_(WrappedRow.class, (Iterable)ImmutableList.of((Object)Types.castIfNecessary(Row.class, (Expression)input)), (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, Object.class, (String)"field", (Iterable)ImmutableList.of((Object)row, (Object)index), (BlockStatement)body.toBlock())));
        }
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized String processElementBlock;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> jarPaths;
        @DoFn.FieldAccess(value="row")
        private final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess;
        private @UnknownKeyFor @NonNull @Initialized boolean collectErrors;
        private transient @Nullable @UnknownKeyFor @Initialized ScriptEvaluator se = null;
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CalcFn.class);

        public CalcFn(@UnknownKeyFor @NonNull @Initialized String processElementBlock, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> jarPaths, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess, @UnknownKeyFor @NonNull @Initialized boolean collectErrors) {
            this.processElementBlock = processElementBlock;
            this.outputSchema = outputSchema;
            this.verifyRowValues = verifyRowValues;
            this.jarPaths = jarPaths;
            this.fieldAccess = fieldAccess;
            this.collectErrors = collectErrors;
            CalcFn.compile(processElementBlock, jarPaths);
        }

        private static @UnknownKeyFor @NonNull @Initialized ScriptEvaluator compile(@UnknownKeyFor @NonNull @Initialized String processElementBlock, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> jarPaths) {
            ScriptEvaluator se = new ScriptEvaluator();
            if (!jarPaths.isEmpty()) {
                try {
                    JavaUdfLoader udfLoader = new JavaUdfLoader();
                    ClassLoader classLoader = udfLoader.createClassLoader(jarPaths);
                    se.setParentClassLoader(classLoader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load user-provided jar(s).", e);
                }
            }
            se.setParameters(new String[]{rowParam.name, DataContext.ROOT.name}, new Class[]{(Class)rowParam.getType(), (Class)DataContext.ROOT.getType()});
            se.setReturnType(Object[].class);
            try {
                se.cook(processElementBlock);
            }
            catch (CompileException e) {
                throw new UnsupportedOperationException("Could not compile CalcFn: " + processElementBlock, e);
            }
            return se;
        }

        @DoFn.Setup
        public void setup() {
            this.se = CalcFn.compile(this.processElementBlock, this.jarPaths);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.FieldAccess(value="row") @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> outputReceiver, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver multiOutputReceiver) {
            assert (this.se != null);
            try {
                Object[] v = (Object[])this.se.evaluate(new Object[]{row, CONTEXT_INSTANCE});
                if (v != null) {
                    Row output = BeamCalcRel.toBeamRow(Arrays.asList(v), this.outputSchema, this.verifyRowValues);
                    outputReceiver.output((Object)output);
                }
            }
            catch (InvocationTargetException e) {
                if (this.collectErrors) {
                    Schema schema = BeamSqlRelUtils.getErrorRowSchema(row.getSchema());
                    Row errorRow = BeamCalcRel.toBeamRow(Arrays.asList(row.getValues(), e.getCause().getMessage()), schema, true);
                    LOG.error("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
                    multiOutputReceiver.get(errors).output((Object)errorRow);
                }
                throw new RuntimeException("CalcFn failed to evaluate: " + this.processElementBlock, e.getCause());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized POutput> errorsTransformer;

        Transform() {
        }

        Transform(PTransform<PCollection<Row>, ? extends POutput> errorsTransformer) {
            this.errorsTransformer = errorsTransformer;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamCalcRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema(BeamCalcRel.this.getRowType());
            SqlConformanceEnum conformance = SqlConformanceEnum.MYSQL_5;
            JavaTypeFactory typeFactory = BeamJavaTypeFactory.INSTANCE;
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)BeamCalcRel.this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
            RexBuilder rexBuilder = BeamCalcRel.this.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(BeamCalcRel.this.getInput());
            RexSimplify simplify = new RexSimplify(rexBuilder, predicates, RexUtil.EXECUTOR);
            RexProgram program = BeamCalcRel.this.getProgram().normalize(rexBuilder, simplify);
            InputGetterImpl inputGetter = new InputGetterImpl((Expression)rowParam, upstream.getSchema());
            Expression condition = RexToLixTranslator.translateCondition((RexProgram)program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder, (RexToLixTranslator.InputGetter)inputGetter, null, (SqlConformance)conformance);
            List expressions = RexToLixTranslator.translateProjects((RexProgram)program, (JavaTypeFactory)typeFactory, (SqlConformance)conformance, (BlockBuilder)builder, (PhysType)physType, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)inputGetter, null);
            builder.add((Statement)Expressions.ifThenElse((Expression)condition, (Node)Expressions.return_(null, (Expression)physType.record(expressions)), (Node)Expressions.return_(null, (Expression)Expressions.constant(null))));
            BeamSqlPipelineOptions options = (BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class);
            CalcFn calcFn = new CalcFn(builder.toBlock().toString(), outputSchema, options.getVerifyRowValues(), BeamCalcRel.getJarPaths(program), inputGetter.getFieldAccess(), this.errorsTransformer != null);
            PCollectionTuple tuple = (PCollectionTuple)upstream.apply((PTransform)ParDo.of((DoFn)calcFn).withOutputTags(rows, TupleTagList.of((TupleTag)errors)));
            PCollection errorPCollection = tuple.get(errors).setCoder((Coder)BeamCalcRel.this.getErrorRowCoder((PCollection<Row>)upstream, inputGetter));
            if (this.errorsTransformer != null) {
                errorPCollection.apply(this.errorsTransformer);
            }
            return tuple.get(rows).setRowSchema(outputSchema);
        }
    }
}

