/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDropCatalog
extends SqlDrop
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SqlDropCatalog.class);
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("DROP CATALOG", SqlKind.OTHER_DDL);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogName;

    public SqlDropCatalog(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean ifExists, @UnknownKeyFor @NonNull @Initialized SqlNode catalogName) {
        super(OPERATOR, pos, ifExists);
        this.catalogName = SqlDdlNodes.getIdentifier(catalogName, pos);
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.catalogName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.catalogName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        String name = (String)pair.right;
        if (!(schema instanceof BeamCalciteSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Schema is not of instance BeamCalciteSchema"));
        }
        BeamCalciteSchema beamCalciteSchema = (BeamCalciteSchema)schema;
        @Nullable CatalogManager catalogManager = beamCalciteSchema.getCatalogManager();
        if (catalogManager == null) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unexpected 'DROP CATALOG' call for Schema '%s' that is not a Catalog.", name)));
        }
        if (catalogManager.getCatalog(name) == null) {
            if (!this.ifExists) {
                throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Cannot drop catalog: '%s' not found.", name)));
            }
            LOG.info("Ignoring 'DROP CATALOG` call for non-existent catalog: {}", (Object)name);
            return;
        }
        if (catalogManager.currentCatalog().name().equals(name)) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unable to drop active catalog '%s'. Please switch to another catalog first.", name)));
        }
        catalogManager.dropCatalog(name);
        LOG.info("Successfully dropped catalog '{}'", (Object)name);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.catalogName);
    }
}

