/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchemaFactory;
import org.apache.beam.sdk.extensions.sql.impl.CalciteConnectionWrapper;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JdbcConnection
extends CalciteConnectionWrapper {
    private static final @UnknownKeyFor @NonNull @Initialized String PIPELINE_OPTION_PREFIX = "beam.";
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptionsMap = Collections.emptyMap();
    private @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions;

    private JdbcConnection(@UnknownKeyFor @NonNull @Initialized CalciteConnection connection) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        super(connection);
    }

    static @Nullable @UnknownKeyFor @Initialized JdbcConnection initialize(@UnknownKeyFor @NonNull @Initialized CalciteConnection connection) {
        try {
            if (connection == null) {
                return null;
            }
            JdbcConnection jdbcConnection = new JdbcConnection(connection);
            jdbcConnection.setPipelineOptionsMap(JdbcConnection.extractPipelineOptions(connection));
            jdbcConnection.setSchema(connection.getSchema(), BeamCalciteSchemaFactory.catalogFromInitialEmptySchema(jdbcConnection));
            return jdbcConnection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> extractPipelineOptions(@UnknownKeyFor @NonNull @Initialized CalciteConnection calciteConnection) {
        return calciteConnection.getProperties().entrySet().stream().map(entry -> KV.of((Object)entry.getKey().toString(), (Object)entry.getValue().toString())).filter(kv -> ((String)kv.getKey()).startsWith(PIPELINE_OPTION_PREFIX)).map(kv -> KV.of((Object)((String)kv.getKey()).substring(PIPELINE_OPTION_PREFIX.length()), (Object)((String)kv.getValue()))).collect(Collectors.toMap(KV::getKey, KV::getValue));
    }

    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getPipelineOptionsMap() {
        return this.pipelineOptionsMap;
    }

    public void setPipelineOptionsMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> pipelineOptionsMap) {
        this.pipelineOptionsMap = ImmutableMap.copyOf(pipelineOptionsMap);
    }

    public void setPipelineOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
        return this.pipelineOptions;
    }

    <T> T getCurrentBeamSchema() {
        try {
            return (T)CalciteSchema.from((SchemaPlus)this.getRootSchema().getSubSchema((String)this.getSchema())).schema;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaPlus getCurrentSchemaPlus() {
        try {
            return this.getRootSchema().getSubSchema(this.getSchema());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void setSchema(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        BeamCalciteSchema beamCalciteSchema = new BeamCalciteSchema(this, tableProvider);
        this.getRootSchema().add(name, (Schema)beamCalciteSchema);
    }

    void setSchema(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        BeamCalciteSchema beamCalciteSchema = new BeamCalciteSchema(this, catalogManager);
        this.getRootSchema().add(name, (Schema)beamCalciteSchema);
    }
}

