/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class BigDecimalConverter {
    private static final Map<Schema.TypeName, SerializableFunction<BigDecimal, ? extends Number>> CONVERTER_MAP = ImmutableMap.builder().put(Schema.TypeName.INT32, BigDecimal::intValue).put(Schema.TypeName.INT16, (SerializableFunction & Serializable)((SerializableFunction & Serializable)Number::shortValue)).put(Schema.TypeName.BYTE, (SerializableFunction & Serializable)((SerializableFunction & Serializable)Number::byteValue)).put(Schema.TypeName.INT64, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::longValue)).put(Schema.TypeName.FLOAT, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::floatValue)).put(Schema.TypeName.DOUBLE, (SerializableFunction & Serializable)((SerializableFunction & Serializable)BigDecimal::doubleValue)).put(Schema.TypeName.DECIMAL, (SerializableFunction & Serializable)(SerializableFunction & Serializable)v -> v).build();

    public static SerializableFunction<BigDecimal, ? extends Number> forSqlType(Schema.TypeName typeName) {
        if (!CONVERTER_MAP.containsKey(typeName)) {
            throw new UnsupportedOperationException("Conversion from " + typeName + " to BigDecimal is not supported");
        }
        return CONVERTER_MAP.get(typeName);
    }
}

