/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.SqlTypeUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;

public class BeamSqlDatetimePlusExpression
extends BeamSqlExpression {
    private static final Set<SqlTypeName> SUPPORTED_INTERVAL_TYPES = ImmutableSet.of(SqlTypeName.INTERVAL_SECOND, SqlTypeName.INTERVAL_MINUTE, SqlTypeName.INTERVAL_HOUR, SqlTypeName.INTERVAL_DAY, SqlTypeName.INTERVAL_MONTH, SqlTypeName.INTERVAL_YEAR, new SqlTypeName[0]);

    public BeamSqlDatetimePlusExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.TIMESTAMP);
    }

    @Override
    public boolean accept() {
        return this.operands.size() == 2 && SqlTypeName.DATETIME_TYPES.contains((Object)((BeamSqlExpression)this.operands.get(0)).getOutputType()) && SUPPORTED_INTERVAL_TYPES.contains((Object)((BeamSqlExpression)this.operands.get(1)).getOutputType());
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        DateTime timestamp = this.getTimestampOperand(inputRow, window, env);
        BeamSqlPrimitive intervalOperandPrimitive = this.getIntervalOperand(inputRow, window, env);
        SqlTypeName intervalOperandType = intervalOperandPrimitive.getOutputType();
        int intervalMultiplier = this.getIntervalMultiplier(intervalOperandPrimitive);
        DateTime newDate = this.addInterval(timestamp, intervalOperandType, intervalMultiplier);
        return BeamSqlPrimitive.of(SqlTypeName.TIMESTAMP, newDate);
    }

    private int getIntervalMultiplier(BeamSqlPrimitive intervalOperandPrimitive) {
        BigDecimal intervalOperandValue = intervalOperandPrimitive.getDecimal();
        BigDecimal multiplier = intervalOperandValue.divide(TimeUnitUtils.timeUnitInternalMultiplier(intervalOperandPrimitive.getOutputType()), 2);
        return multiplier.intValueExact();
    }

    private BeamSqlPrimitive getIntervalOperand(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        return SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SUPPORTED_INTERVAL_TYPES).get().evaluate(inputRow, window, env);
    }

    private DateTime getTimestampOperand(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        BeamSqlPrimitive timestampOperandPrimitive = SqlTypeUtils.findExpressionOfType((List<BeamSqlExpression>)this.operands, SqlTypeName.DATETIME_TYPES).get().evaluate(inputRow, window, env);
        return new DateTime((Object)timestampOperandPrimitive.getDate());
    }

    private DateTime addInterval(DateTime dateTime, SqlTypeName intervalType, int numberOfIntervals) {
        switch (intervalType) {
            case INTERVAL_SECOND: {
                return dateTime.plusSeconds(numberOfIntervals);
            }
            case INTERVAL_MINUTE: {
                return dateTime.plusMinutes(numberOfIntervals);
            }
            case INTERVAL_HOUR: {
                return dateTime.plusHours(numberOfIntervals);
            }
            case INTERVAL_DAY: {
                return dateTime.plusDays(numberOfIntervals);
            }
            case INTERVAL_MONTH: {
                return dateTime.plusMonths(numberOfIntervals);
            }
            case INTERVAL_YEAR: {
                return dateTime.plusYears(numberOfIntervals);
            }
        }
        throw new IllegalArgumentException("Adding " + intervalType.getName() + " to date is not supported");
    }
}

