/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.SqlTransform;

final class AutoValue_SqlTransform
extends SqlTransform {
    private final String queryString;
    private final List<SqlTransform.UdfDefinition> udfDefinitions;
    private final List<SqlTransform.UdafDefinition> udafDefinitions;

    private AutoValue_SqlTransform(String queryString, List<SqlTransform.UdfDefinition> udfDefinitions, List<SqlTransform.UdafDefinition> udafDefinitions) {
        this.queryString = queryString;
        this.udfDefinitions = udfDefinitions;
        this.udafDefinitions = udafDefinitions;
    }

    @Override
    String queryString() {
        return this.queryString;
    }

    @Override
    List<SqlTransform.UdfDefinition> udfDefinitions() {
        return this.udfDefinitions;
    }

    @Override
    List<SqlTransform.UdafDefinition> udafDefinitions() {
        return this.udafDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SqlTransform) {
            SqlTransform that = (SqlTransform)((Object)o);
            return this.queryString.equals(that.queryString()) && this.udfDefinitions.equals(that.udfDefinitions()) && this.udafDefinitions.equals(that.udafDefinitions());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.queryString.hashCode();
        h *= 1000003;
        h ^= this.udfDefinitions.hashCode();
        h *= 1000003;
        return h ^= this.udafDefinitions.hashCode();
    }

    @Override
    SqlTransform.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SqlTransform.Builder {
        private String queryString;
        private List<SqlTransform.UdfDefinition> udfDefinitions;
        private List<SqlTransform.UdafDefinition> udafDefinitions;

        Builder() {
        }

        private Builder(SqlTransform source) {
            this.queryString = source.queryString();
            this.udfDefinitions = source.udfDefinitions();
            this.udafDefinitions = source.udafDefinitions();
        }

        @Override
        SqlTransform.Builder setQueryString(String queryString) {
            if (queryString == null) {
                throw new NullPointerException("Null queryString");
            }
            this.queryString = queryString;
            return this;
        }

        @Override
        SqlTransform.Builder setUdfDefinitions(List<SqlTransform.UdfDefinition> udfDefinitions) {
            if (udfDefinitions == null) {
                throw new NullPointerException("Null udfDefinitions");
            }
            this.udfDefinitions = udfDefinitions;
            return this;
        }

        @Override
        SqlTransform.Builder setUdafDefinitions(List<SqlTransform.UdafDefinition> udafDefinitions) {
            if (udafDefinitions == null) {
                throw new NullPointerException("Null udafDefinitions");
            }
            this.udafDefinitions = udafDefinitions;
            return this;
        }

        @Override
        SqlTransform build() {
            String missing = "";
            if (this.queryString == null) {
                missing = missing + " queryString";
            }
            if (this.udfDefinitions == null) {
                missing = missing + " udfDefinitions";
            }
            if (this.udafDefinitions == null) {
                missing = missing + " udafDefinitions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SqlTransform(this.queryString, this.udfDefinitions, this.udafDefinitions);
        }
    }
}

