/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexProgram;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public abstract class AbstractBeamCalcRel
extends Calc
implements BeamRelNode {
    public AbstractBeamCalcRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        super(cluster, traits, input, program);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isInputSortRelAndLimitOnly() {
        return this.input instanceof BeamSortRel && ((BeamSortRel)this.input).isLimitOnly();
    }

    public @UnknownKeyFor @NonNull @Initialized int getLimitCountOfSortRel() {
        if (this.input instanceof BeamSortRel) {
            return ((BeamSortRel)this.input).getCount();
        }
        throw new RuntimeException("Could not get the limit count from a non BeamSortRel input.");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    public @UnknownKeyFor @NonNull @Initialized boolean deepEquals(@UnknownKeyFor @NonNull @Initialized Object obj) {
        if (!super.deepEquals(obj) || !(obj instanceof AbstractBeamCalcRel)) {
            return false;
        }
        AbstractBeamCalcRel other = (AbstractBeamCalcRel)obj;
        return this.getRowType().getFieldNames().equals(other.getRowType().getFieldNames());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        double selectivity = AbstractBeamCalcRel.estimateFilterSelectivity(this.getInput(), this.program, mq);
        return inputStat.multiply(selectivity);
    }

    private static @UnknownKeyFor @NonNull @Initialized double estimateFilterSelectivity(@UnknownKeyFor @NonNull @Initialized RelNode child, @UnknownKeyFor @NonNull @Initialized RexProgram program, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
        RexLocalRef programCondition = program.getCondition();
        RexNode condition = programCondition == null ? null : program.expandLocalRef(programCondition);
        return mq.getSelectivity(child, condition);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputStat = BeamSqlRelUtils.getNodeStats(this.input, mq);
        return BeamCostModel.FACTORY.makeCost(inputStat.getRowCount(), inputStat.getRate());
    }
}

