/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigtable;

import com.alibaba.fastjson.JSONObject;
import com.google.bigtable.v2.Row;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InvalidTableException;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigtable.BigtableFilter;
import org.apache.beam.sdk.io.gcp.bigtable.BeamRowToBigtableMutation;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRow;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableRowToBeamRowFlat;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BigtableTable
extends SchemaBaseBeamTable
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized Pattern locationPattern = Pattern.compile("(?<host>.+)/bigtable/projects/(?<projectId>.+)/instances/(?<instanceId>.+)/tables/(?<tableId>.+)");
    private final @UnknownKeyFor @NonNull @Initialized String projectId;
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;
    private @UnknownKeyFor @NonNull @Initialized String emulatorHost = "";
    private @UnknownKeyFor @NonNull @Initialized boolean useFlatSchema = false;
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping = Maps.newHashMap();

    BigtableTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        super(table.getSchema());
        JSONObject properties;
        BigtableTable.validateSchema(this.schema);
        String location = table.getLocation();
        if (location == null) {
            throw new IllegalStateException("LOCATION is required");
        }
        Matcher matcher = locationPattern.matcher(location);
        BigtableTable.validateMatcher(matcher, location);
        this.projectId = BigtableTable.getMatcherValue(matcher, "projectId");
        this.instanceId = BigtableTable.getMatcherValue(matcher, "instanceId");
        this.tableId = BigtableTable.getMatcherValue(matcher, "tableId");
        String host = BigtableTable.getMatcherValue(matcher, "host");
        if (!"googleapis.com".equals(host)) {
            this.emulatorHost = host;
        }
        if ((properties = table.getProperties()).containsKey((Object)"columnsMapping")) {
            this.columnsMapping = BigtableTable.parseColumnsMapping(properties.getString("columnsMapping"));
            BigtableTable.validateColumnsMapping(this.columnsMapping, this.schema);
            this.useFlatSchema = true;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return ((PCollection)this.readTransform().expand(begin).apply("BigtableRowToBeamRow", this.bigtableRowToRow())).setRowSchema(this.schema);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filters, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        BigtableIO.Read readTransform = this.readTransform();
        if (filters instanceof BigtableFilter) {
            BigtableFilter bigtableFilter = (BigtableFilter)filters;
            readTransform = readTransform.withRowFilter(bigtableFilter.getFilters());
        }
        return (PCollection)readTransform.expand(begin).apply(this.bigtableRowToRow());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row> input) {
        if (!this.useFlatSchema) {
            throw new UnsupportedOperationException("Write to Cloud Bigtable is supported for flat schema only.");
        }
        BigtableIO.Write write = BigtableIO.write().withProjectId(this.projectId).withInstanceId(this.instanceId).withTableId(this.tableId);
        if (!this.emulatorHost.isEmpty()) {
            write = write.withEmulator(this.emulatorHost);
        }
        return ((PCollection)input.apply((PTransform)new BeamRowToBigtableMutation(this.columnsMapping))).apply((PTransform)write);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter constructFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> filter) {
        return new BigtableFilter(filter, this.schema);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> parseColumnsMapping(@UnknownKeyFor @NonNull @Initialized String commaSeparatedMapping) {
        HashMap<String, Set<String>> columnsMapping = new HashMap<String, Set<String>>();
        Splitter.on((String)",").splitToList((CharSequence)commaSeparatedMapping).forEach(colonSeparatedValues -> {
            List pair = Splitter.on((String)":").splitToList((CharSequence)colonSeparatedValues);
            columnsMapping.putIfAbsent((String)pair.get(0), Sets.newHashSet());
            ((Set)columnsMapping.get(pair.get(0))).add((String)pair.get(1));
        });
        return columnsMapping;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getMatcherValue(@UnknownKeyFor @NonNull @Initialized Matcher matcher, @UnknownKeyFor @NonNull @Initialized String field) {
        String value = matcher.group(field);
        return value == null ? "" : value;
    }

    private static void validateSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (!schema.hasField("key")) {
            throw new IllegalStateException(String.format("Schema has to contain '%s' field", "key"));
        }
        Schema.Field keyField = schema.getField("key");
        if (keyField != null && Schema.TypeName.STRING != keyField.getType().getTypeName()) {
            throw new IllegalArgumentException("key field type should be STRING but was " + keyField.getType().getTypeName());
        }
    }

    private static void validateMatcher(@UnknownKeyFor @NonNull @Initialized Matcher matcher, @UnknownKeyFor @NonNull @Initialized String location) {
        if (!matcher.matches()) {
            throw new InvalidTableException("Bigtable location must be in the following format: 'googleapis.com/bigtable/projects/projectId/instances/instanceId/tables/tableId' but was: " + location);
        }
    }

    private static void validateColumnsMapping(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        BigtableTable.validateColumnsMappingCount(columnsMapping, schema);
        BigtableTable.validateColumnsMappingFields(columnsMapping, schema);
    }

    private static void validateColumnsMappingCount(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        int mappingCount = columnsMapping.values().stream().mapToInt(Set::size).sum();
        int qualifiersCount = schema.getFieldCount() - 1;
        if (qualifiersCount != mappingCount) {
            throw new IllegalStateException(String.format("Schema fields count: '%s' does not fit columnsMapping count: '%s'", qualifiersCount, mappingCount));
        }
    }

    private static void validateColumnsMappingFields(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String>> columnsMapping, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        Set allMappingQualifiers = columnsMapping.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Set schemaFieldNames = schema.getFieldNames().stream().filter(field -> !"key".equals(field)).collect(Collectors.toSet());
        if (!schemaFieldNames.equals(allMappingQualifiers)) {
            throw new IllegalStateException(String.format("columnsMapping '%s' does not fit to schema field names '%s'", allMappingQualifiers, schemaFieldNames));
        }
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableIO.Read readTransform() {
        BigtableIO.Read readTransform = BigtableIO.read().withProjectId(this.projectId).withInstanceId(this.instanceId).withTableId(this.tableId);
        if (!this.emulatorHost.isEmpty()) {
            readTransform = readTransform.withEmulator(this.emulatorHost);
        }
        return readTransform;
    }

    private @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized org.apache.beam.sdk.values.Row>> bigtableRowToRow() {
        return this.useFlatSchema ? new BigtableRowToBeamRowFlat(this.schema, this.columnsMapping) : new BigtableRowToBeamRow(this.schema);
    }
}

