/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import com.alibaba.fastjson.JSONObject;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.commons.csv.CSVFormat;

public class TextTableProvider
extends InMemoryMetaTableProvider {
    @Override
    public String getTableType() {
        return "text";
    }

    @Override
    public BeamSqlTable buildBeamSqlTable(Table table) {
        Schema schema = table.getSchema();
        String filePattern = table.getLocation();
        CSVFormat format = CSVFormat.DEFAULT;
        JSONObject properties = table.getProperties();
        String csvFormatStr = properties.getString("format");
        if (csvFormatStr != null && !csvFormatStr.isEmpty()) {
            format = CSVFormat.valueOf((String)csvFormatStr);
        }
        BeamTextCSVTable txtTable = new BeamTextCSVTable(schema, filePattern, format);
        return txtTable;
    }
}

