/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.string.BeamSqlStringUnaryExpression;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlInitCapExpression
extends BeamSqlStringUnaryExpression {
    public BeamSqlInitCapExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.VARCHAR);
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        String str = (String)this.opValueEvaluated(0, inputRow, window, correlateEnv);
        StringBuilder ret = new StringBuilder(str);
        boolean isInit = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) {
                isInit = true;
                continue;
            }
            if (isInit) {
                ret.setCharAt(i, Character.toUpperCase(str.charAt(i)));
                isInit = false;
                continue;
            }
            ret.setCharAt(i, Character.toLowerCase(str.charAt(i)));
        }
        return BeamSqlPrimitive.of(SqlTypeName.VARCHAR, ret.toString());
    }
}

