/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.math;

import java.util.List;
import java.util.Random;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlRandIntegerExpression
extends BeamSqlExpression {
    private Random rand = new Random();
    private Integer seed = null;

    public BeamSqlRandIntegerExpression(List<BeamSqlExpression> subExps) {
        super(subExps, SqlTypeName.INTEGER);
    }

    @Override
    public boolean accept() {
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        int numericIdx = 0;
        if (this.operands.size() == 2) {
            int rowSeed = (Integer)this.opValueEvaluated(0, inputRow, window, correlateEnv);
            if (this.seed == null || this.seed != rowSeed) {
                this.rand.setSeed(rowSeed);
            }
            numericIdx = 1;
        }
        return BeamSqlPrimitive.of(SqlTypeName.INTEGER, this.rand.nextInt((Integer)this.opValueEvaluated(numericIdx, inputRow, window, correlateEnv)));
    }
}

