/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public abstract class BeamSqlExpression
implements Serializable {
    protected List<BeamSqlExpression> operands;
    protected SqlTypeName outputType;

    protected BeamSqlExpression() {
    }

    public BeamSqlExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        this.operands = operands;
        this.outputType = outputType;
    }

    public BeamSqlExpression op(int idx) {
        return this.operands.get(idx);
    }

    public SqlTypeName opType(int idx) {
        return this.op(idx).getOutputType();
    }

    public <T> T opValueEvaluated(int idx, Row row, BoundedWindow window, ImmutableMap<Integer, Object> correlateEnv) {
        return this.op(idx).evaluate(row, window, correlateEnv).getValue();
    }

    public abstract boolean accept();

    public abstract BeamSqlPrimitive evaluate(Row var1, BoundedWindow var2, ImmutableMap<Integer, Object> var3);

    public List<BeamSqlExpression> getOperands() {
        return this.operands;
    }

    public SqlTypeName getOutputType() {
        return this.outputType;
    }

    public int numberOfOperands() {
        return this.operands.size();
    }
}

