/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableCollection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.AutoValue_QueryTransform;
import org.apache.beam.sdk.extensions.sql.AutoValue_QueryTransform_UdafDefinition;
import org.apache.beam.sdk.extensions.sql.AutoValue_QueryTransform_UdfDefinition;
import org.apache.beam.sdk.extensions.sql.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.BeamSqlUdf;
import org.apache.beam.sdk.extensions.sql.SchemaHelper;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamPCollectionTable;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;

@AutoValue
public abstract class QueryTransform
extends PTransform<PInput, PCollection<Row>> {
    static final String PCOLLECTION_NAME = "PCOLLECTION";

    abstract String queryString();

    abstract List<UdfDefinition> udfDefinitions();

    abstract List<UdafDefinition> udafDefinitions();

    public PCollection<Row> expand(PInput input) {
        BeamSqlEnv sqlEnv = BeamSqlEnv.readOnly(PCOLLECTION_NAME, this.toTableMap(input));
        this.registerFunctions(sqlEnv);
        return (PCollection)PCollectionTuple.empty((Pipeline)input.getPipeline()).apply(sqlEnv.parseQuery(this.queryString()));
    }

    private Map<String, BeamSqlTable> toTableMap(PInput inputs) {
        if (inputs instanceof PCollection) {
            return ImmutableMap.of(PCOLLECTION_NAME, new BeamPCollectionTable(SchemaHelper.toRows(inputs)));
        }
        ImmutableMap.Builder<String, BeamPCollectionTable> tables = ImmutableMap.builder();
        for (Map.Entry input : inputs.expand().entrySet()) {
            tables.put(((TupleTag)input.getKey()).getId(), new BeamPCollectionTable(SchemaHelper.toRows((PInput)input.getValue())));
        }
        return tables.build();
    }

    private void registerFunctions(BeamSqlEnv sqlEnv) {
        this.udfDefinitions().forEach(udf -> sqlEnv.registerUdf(udf.udfName(), udf.clazz(), udf.methodName()));
        this.udafDefinitions().forEach(udaf -> sqlEnv.registerUdaf(udaf.udafName(), udaf.combineFn()));
    }

    public static QueryTransform withQueryString(String queryString) {
        return QueryTransform.builder().setQueryString(queryString).setUdafDefinitions(Collections.emptyList()).setUdfDefinitions(Collections.emptyList()).build();
    }

    public QueryTransform registerUdf(String functionName, Class<? extends BeamSqlUdf> clazz) {
        return this.registerUdf(functionName, clazz, "eval");
    }

    public QueryTransform registerUdf(String functionName, SerializableFunction sfn) {
        return this.registerUdf(functionName, sfn.getClass(), "apply");
    }

    private QueryTransform registerUdf(String functionName, Class<?> clazz, String method) {
        ImmutableCollection newUdfDefinitions = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.udfDefinitions())).add(UdfDefinition.of(functionName, clazz, method))).build();
        return this.toBuilder().setUdfDefinitions((List<UdfDefinition>)((Object)newUdfDefinitions)).build();
    }

    public QueryTransform registerUdaf(String functionName, Combine.CombineFn combineFn) {
        ImmutableCollection newUdafs = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.udafDefinitions())).add(UdafDefinition.of(functionName, combineFn))).build();
        return this.toBuilder().setUdafDefinitions((List<UdafDefinition>)((Object)newUdafs)).build();
    }

    abstract Builder toBuilder();

    static Builder builder() {
        return new AutoValue_QueryTransform.Builder();
    }

    @AutoValue
    static abstract class UdafDefinition {
        UdafDefinition() {
        }

        abstract String udafName();

        abstract Combine.CombineFn combineFn();

        static UdafDefinition of(String udafName, Combine.CombineFn combineFn) {
            return new AutoValue_QueryTransform_UdafDefinition(udafName, combineFn);
        }
    }

    @AutoValue
    static abstract class UdfDefinition {
        UdfDefinition() {
        }

        abstract String udfName();

        abstract Class<?> clazz();

        abstract String methodName();

        static UdfDefinition of(String udfName, Class<?> clazz, String methodName) {
            return new AutoValue_QueryTransform_UdfDefinition(udfName, clazz, methodName);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setQueryString(String var1);

        abstract Builder setUdfDefinitions(List<UdfDefinition> var1);

        abstract Builder setUdafDefinitions(List<UdafDefinition> var1);

        abstract QueryTransform build();
    }
}

