/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.values.PCollectionTuple;

@Experimental
public class BeamSqlCli {
    private BeamSqlEnv env;
    private MetaStore metaStore;

    public BeamSqlCli metaStore(MetaStore metaStore) {
        this.metaStore = metaStore;
        this.env = BeamSqlEnv.withTableProvider(metaStore);
        return this;
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    public String explainQuery(String sqlString) throws ParseException {
        return this.env.explain(sqlString);
    }

    public void execute(String sqlString) throws ParseException {
        if (this.env.isDdl(sqlString)) {
            this.env.executeDdl(sqlString);
        } else {
            PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])new String[0]).withValidation().as(PipelineOptions.class);
            options.setJobName("BeamPlanCreator");
            Pipeline pipeline = Pipeline.create((PipelineOptions)options);
            PCollectionTuple.empty((Pipeline)pipeline).apply(this.env.parseQuery(sqlString));
            pipeline.run();
        }
    }
}

