/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.DateString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.DateTimeStringUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimeString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimestampString;

public class TimestampWithTimeZoneString
implements Comparable<TimestampWithTimeZoneString> {
    final TimestampString localDateTime;
    final TimeZone timeZone;
    final String v;

    public TimestampWithTimeZoneString(TimestampString localDateTime, TimeZone timeZone) {
        this.localDateTime = localDateTime;
        this.timeZone = timeZone;
        this.v = localDateTime.toString() + " " + timeZone.getID();
    }

    public TimestampWithTimeZoneString(String v) {
        this.localDateTime = new TimestampString(v.substring(0, v.indexOf(32, 11)));
        String timeZoneString = v.substring(v.indexOf(32, 11) + 1);
        Preconditions.checkArgument(DateTimeStringUtils.isValidTimeZone(timeZoneString));
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.v = v;
    }

    public TimestampWithTimeZoneString(int year, int month, int day, int h, int m, int s, String timeZone) {
        this(DateTimeStringUtils.ymdhms(new StringBuilder(), year, month, day, h, m, s).toString() + " " + timeZone);
    }

    public TimestampWithTimeZoneString withMillis(int millis) {
        Preconditions.checkArgument(millis >= 0 && millis < 1000);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimestampWithTimeZoneString withNanos(int nanos) {
        Preconditions.checkArgument(nanos >= 0 && nanos < 1000000000);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimestampWithTimeZoneString withFraction(String fraction) {
        return new TimestampWithTimeZoneString(this.localDateTime.withFraction(fraction), this.timeZone);
    }

    public TimestampWithTimeZoneString withTimeZone(TimeZone timeZone) {
        String fraction;
        String v;
        if (this.timeZone.equals(timeZone)) {
            return this;
        }
        String localDateTimeString = this.localDateTime.toString();
        int i = localDateTimeString.indexOf(46);
        if (i >= 0) {
            v = localDateTimeString.substring(0, i);
            fraction = localDateTimeString.substring(i + 1);
        } else {
            v = localDateTimeString;
            fraction = null;
        }
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(v, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT), this.timeZone, -1);
        pt.getCalendar().setTimeZone(timeZone);
        if (fraction != null) {
            return new TimestampWithTimeZoneString(pt.getCalendar().get(1), pt.getCalendar().get(2) + 1, pt.getCalendar().get(5), pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID()).withFraction(fraction);
        }
        return new TimestampWithTimeZoneString(pt.getCalendar().get(1), pt.getCalendar().get(2) + 1, pt.getCalendar().get(5), pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID());
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof TimestampWithTimeZoneString && ((TimestampWithTimeZoneString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimestampWithTimeZoneString o) {
        return this.v.compareTo(o.v);
    }

    public TimestampWithTimeZoneString round(int precision) {
        Preconditions.checkArgument(precision >= 0);
        return new TimestampWithTimeZoneString(this.localDateTime.round(precision), this.timeZone);
    }

    public static TimestampWithTimeZoneString fromMillisSinceEpoch(long millis) {
        return new TimestampWithTimeZoneString(DateTimeUtils.unixTimestampToString(millis) + " " + DateTimeUtils.UTC_ZONE.getID()).withMillis((int)DateTimeUtils.floorMod(millis, 1000L));
    }

    public String toString(int precision) {
        Preconditions.checkArgument(precision >= 0);
        return this.localDateTime.toString(precision) + " " + this.timeZone.getID();
    }

    public DateString getLocalDateString() {
        return new DateString(this.localDateTime.toString().substring(0, 10));
    }

    public TimeString getLocalTimeString() {
        return new TimeString(this.localDateTime.toString().substring(11));
    }

    public TimestampString getLocalTimestampString() {
        return this.localDateTime;
    }
}

