/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.StructKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.ListScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.ScopeChild;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorScope;

public class MatchRecognizeScope
extends ListScope {
    private static final String STAR = "*";
    private final SqlMatchRecognize matchRecognize;
    private final Set<String> patternVars;

    public MatchRecognizeScope(SqlValidatorScope parent, SqlMatchRecognize matchRecognize) {
        super(parent);
        this.matchRecognize = matchRecognize;
        this.patternVars = this.validator.getCatalogReader().nameMatcher().isCaseSensitive() ? new LinkedHashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.patternVars.add(STAR);
    }

    @Override
    public SqlNode getNode() {
        return this.matchRecognize;
    }

    public SqlMatchRecognize getMatchRecognize() {
        return this.matchRecognize;
    }

    public Set<String> getPatternVars() {
        return this.patternVars;
    }

    public void addPatternVar(String str) {
        this.patternVars.add(str);
    }

    @Override
    public Map<String, ScopeChild> findQualifyingTableNames(String columnName, SqlNode ctx, SqlNameMatcher nameMatcher) {
        HashMap<String, ScopeChild> map = new HashMap<String, ScopeChild>();
        for (ScopeChild child : this.children) {
            RelDataType rowType = child.namespace.getRowType();
            if (nameMatcher.field(rowType, columnName) == null) continue;
            map.put(STAR, child);
        }
        switch (map.size()) {
            case 0: {
                return this.parent.findQualifyingTableNames(columnName, ctx, nameMatcher);
            }
        }
        return map;
    }

    @Override
    public void resolve(List<String> names, SqlNameMatcher nameMatcher, boolean deep, SqlValidatorScope.Resolved resolved) {
        if (this.patternVars.contains(names.get(0))) {
            SqlValidatorScope.Step path = new SqlValidatorScope.EmptyPath().plus(null, 0, null, StructKind.FULLY_QUALIFIED);
            ScopeChild child = (ScopeChild)this.children.get(0);
            resolved.found(child.namespace, child.nullable, this, path, names);
            if (resolved.count() > 0) {
                return;
            }
        }
        super.resolve(names, nameMatcher, deep, resolved);
    }
}

