/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.CachingLatticeStatisticProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.Lattice;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.LatticeStatisticProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.materialize.MaterializationService;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.ScannableTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.schema.Table;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ImmutableBitSet;

class SqlLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = new LatticeStatisticProvider.Factory(){

        @Override
        public LatticeStatisticProvider apply(Lattice lattice) {
            return new SqlLatticeStatisticProvider(lattice);
        }
    };
    static final LatticeStatisticProvider.Factory CACHED_FACTORY = new LatticeStatisticProvider.Factory(){

        @Override
        public LatticeStatisticProvider apply(Lattice lattice) {
            LatticeStatisticProvider provider = (LatticeStatisticProvider)FACTORY.apply(lattice);
            return new CachingLatticeStatisticProvider(lattice, provider);
        }
    };
    private final Lattice lattice;

    private SqlLatticeStatisticProvider(Lattice lattice) {
        this.lattice = Preconditions.checkNotNull(lattice);
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            counts.add(this.cardinality(this.lattice, column));
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }

    private double cardinality(Lattice lattice, Lattice.Column column) {
        String sql = lattice.countSql(ImmutableBitSet.of(column.ordinal));
        Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, ImmutableList.of());
        Object[] values = Iterables.getOnlyElement(((ScannableTable)table).scan(null));
        return ((Number)values[0]).doubleValue();
    }
}

