/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CountIf;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.VarianceFn;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Max;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamBuiltinAggregations {
    public static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> BUILTIN_AGGREGATOR_FACTORIES = ImmutableMap.builder().put((Object)"ANY_VALUE", typeName -> Sample.anyValueCombineFn()).put((Object)"COUNT", typeName -> new DropNullFnWithDefault(Count.combineFn())).put((Object)"MAX", typeName -> new DropNullFn(BeamBuiltinAggregations.createMax(typeName))).put((Object)"MIN", typeName -> new DropNullFn(BeamBuiltinAggregations.createMin(typeName))).put((Object)"SUM", typeName -> new DropNullFn(BeamBuiltinAggregations.createSum(typeName))).put((Object)"$SUM0", typeName -> new DropNullFnWithDefault(BeamBuiltinAggregations.createSum0(typeName))).put((Object)"AVG", typeName -> new DropNullFn(BeamBuiltinAggregations.createAvg(typeName))).put((Object)"BIT_OR", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitOr(typeName))).put((Object)"BIT_XOR", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitXOr(typeName))).put((Object)"BIT_AND", typeName -> new DropNullFn(BeamBuiltinAggregations.createBitAnd(typeName))).put((Object)"VAR_POP", t -> VarianceFn.newPopulation(t.getTypeName())).put((Object)"VAR_SAMP", t -> VarianceFn.newSample(t.getTypeName())).put((Object)"COVAR_POP", t -> CovarianceFn.newPopulation(t.getTypeName())).put((Object)"COVAR_SAMP", t -> CovarianceFn.newSample(t.getTypeName())).put((Object)"COUNTIF", typeName -> CountIf.combineFn()).build();
    private static @UnknownKeyFor @NonNull @Initialized MathContext mc = new MathContext(10, RoundingMode.HALF_UP);

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> create(@UnknownKeyFor @NonNull @Initialized String functionName, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Function<Schema.FieldType, Combine.CombineFn<?, ?, ?>> aggregatorFactory = BUILTIN_AGGREGATOR_FACTORIES.get(functionName);
        if (aggregatorFactory != null) {
            return aggregatorFactory.apply(fieldType);
        }
        throw new UnsupportedOperationException(String.format("Aggregator [%s] is not supported", functionName));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createMax(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMax();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMax();
            }
            case INT32: {
                return Max.ofIntegers();
            }
            case INT64: {
                return Max.ofLongs();
            }
            case DOUBLE: {
                return Max.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MAX", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createMin(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (CalciteUtils.isDateTimeType(fieldType)) {
            return new CustMin();
        }
        switch (fieldType.getTypeName()) {
            case BOOLEAN: 
            case INT16: 
            case BYTE: 
            case FLOAT: 
            case DATETIME: 
            case DECIMAL: 
            case STRING: {
                return new CustMin();
            }
            case INT32: {
                return Min.ofIntegers();
            }
            case INT64: {
                return Min.ofLongs();
            }
            case DOUBLE: {
                return Min.ofDoubles();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in MIN", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createSum(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return Sum.ofIntegers();
            }
            case INT16: {
                return new ShortSum();
            }
            case BYTE: {
                return new ByteSum();
            }
            case INT64: {
                return new LongSum();
            }
            case FLOAT: {
                return new FloatSum();
            }
            case DOUBLE: {
                return Sum.ofDoubles();
            }
            case DECIMAL: {
                return new BigDecimalSum();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in SUM", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createSum0(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerSum0();
            }
            case INT16: {
                return new ShortSum0();
            }
            case BYTE: {
                return new ByteSum0();
            }
            case INT64: {
                return new LongSum0();
            }
            case FLOAT: {
                return new FloatSum0();
            }
            case DOUBLE: {
                return new DoubleSum0();
            }
            case DECIMAL: {
                return new BigDecimalSum0();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in SUM0", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createAvg(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT32: {
                return new IntegerAvg();
            }
            case INT16: {
                return new ShortAvg();
            }
            case BYTE: {
                return new ByteAvg();
            }
            case INT64: {
                return new LongAvg();
            }
            case FLOAT: {
                return new FloatAvg();
            }
            case DOUBLE: {
                return new DoubleAvg();
            }
            case DECIMAL: {
                return new BigDecimalAvg();
            }
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in AVG", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createBitOr(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitOr();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_OR", fieldType));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createBitAnd(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitAnd();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_AND", fieldType));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn createBitXOr(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        if (fieldType.getTypeName() == Schema.TypeName.INT64) {
            return new BitXOr();
        }
        throw new UnsupportedOperationException(String.format("[%s] is not supported in BIT_XOR", fieldType));
    }

    public static class BitXOr<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, Accum, Long> {
        public @UnknownKeyFor @NonNull @Initialized Accum createAccumulator() {
            return new Accum();
        }

        public @UnknownKeyFor @NonNull @Initialized Accum addInput(@UnknownKeyFor @NonNull @Initialized Accum mutableAccumulator, T input) {
            if (input != null) {
                mutableAccumulator.isEmpty = false;
                mutableAccumulator.bitXOr ^= ((Number)input).longValue();
            }
            return mutableAccumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized Accum mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Accum> accumulators) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accumulators) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitXOr ^= accum.bitXOr;
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Accum accumulator) {
            if (accumulator.isEmpty) {
                return null;
            }
            return accumulator.bitXOr;
        }

        static class Accum
        implements Serializable {
            @UnknownKeyFor @NonNull @Initialized boolean isEmpty = true;
            @UnknownKeyFor @NonNull @Initialized long bitXOr = 0L;

            Accum() {
            }
        }
    }

    static class BitAnd<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, Accum, Long> {
        BitAnd() {
        }

        public @UnknownKeyFor @NonNull @Initialized Accum createAccumulator() {
            return new Accum();
        }

        public @UnknownKeyFor @NonNull @Initialized Accum addInput(@UnknownKeyFor @NonNull @Initialized Accum accum, T input) {
            accum.isEmpty = false;
            accum.bitAnd &= ((Number)input).longValue();
            return accum;
        }

        public @UnknownKeyFor @NonNull @Initialized Accum mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Accum> accums) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accums) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitAnd &= accum.bitAnd;
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Accum accum) {
            if (accum.isEmpty) {
                return null;
            }
            return accum.bitAnd;
        }

        static class Accum
        implements Serializable {
            @UnknownKeyFor @NonNull @Initialized boolean isEmpty = true;
            @UnknownKeyFor @NonNull @Initialized long bitAnd = -1L;

            Accum() {
            }
        }
    }

    static class BitOr<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, Accum, Long> {
        BitOr() {
        }

        public @UnknownKeyFor @NonNull @Initialized Accum createAccumulator() {
            return new Accum();
        }

        public @UnknownKeyFor @NonNull @Initialized Accum addInput(@UnknownKeyFor @NonNull @Initialized Accum accum, T input) {
            accum.isEmpty = false;
            accum.bitOr |= ((Number)input).longValue();
            return accum;
        }

        public @UnknownKeyFor @NonNull @Initialized Accum mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Accum> accums) {
            Accum merged = this.createAccumulator();
            for (Accum accum : accums) {
                if (accum.isEmpty) continue;
                merged.isEmpty = false;
                merged.bitOr |= accum.bitOr;
            }
            return merged;
        }

        public @UnknownKeyFor @NonNull @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized Accum accum) {
            if (accum.isEmpty) {
                return null;
            }
            return accum.bitOr;
        }

        static class Accum
        implements Serializable {
            @UnknownKeyFor @NonNull @Initialized boolean isEmpty = true;
            @UnknownKeyFor @NonNull @Initialized long bitOr = 0L;

            Accum() {
            }
        }
    }

    static class BigDecimalAvg
    extends Avg<BigDecimal> {
        BigDecimalAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized BigDecimal extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : this.prepareOutput(accumulator);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized BigDecimal record) {
            return record;
        }
    }

    static class DoubleAvg
    extends Avg<Double> {
        DoubleAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Double extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Double.valueOf(this.prepareOutput(accumulator).doubleValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Double record) {
            return new BigDecimal(record);
        }
    }

    static class FloatAvg
    extends Avg<Float> {
        FloatAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Float extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Float.valueOf(this.prepareOutput(accumulator).floatValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Float record) {
            return new BigDecimal(record.floatValue());
        }
    }

    static class ByteAvg
    extends Avg<Byte> {
        ByteAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Byte extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Byte.valueOf(this.prepareOutput(accumulator).byteValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Byte record) {
            return new BigDecimal(record.byteValue());
        }
    }

    static class ShortAvg
    extends Avg<Short> {
        ShortAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Short extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Short.valueOf(this.prepareOutput(accumulator).shortValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Short record) {
            return new BigDecimal(record.shortValue());
        }
    }

    static class LongAvg
    extends Avg<Long> {
        LongAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Long extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Long.valueOf(this.prepareOutput(accumulator).longValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Long record) {
            return new BigDecimal(record);
        }
    }

    static class IntegerAvg
    extends Avg<Integer> {
        IntegerAvg() {
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Integer extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return (Integer)accumulator.getKey() == 0 ? null : Integer.valueOf(this.prepareOutput(accumulator).intValue());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(@UnknownKeyFor @NonNull @Initialized Integer record) {
            return new BigDecimal(record);
        }
    }

    static abstract class Avg<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
    extends Combine.CombineFn<T, KV<Integer, BigDecimal>, T> {
        Avg() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> createAccumulator() {
            return KV.of((Object)0, (Object)BigDecimal.ZERO);
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> addInput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator, T input) {
            return KV.of((Object)((Integer)accumulator.getKey() + 1), (Object)((BigDecimal)accumulator.getValue()).add(this.toBigDecimal(input)));
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal>> accumulators) {
            int size = 0;
            BigDecimal acc = BigDecimal.ZERO;
            for (KV<Integer, BigDecimal> ele : accumulators) {
                size += ((Integer)ele.getKey()).intValue();
                acc = acc.add((BigDecimal)ele.getValue());
            }
            return KV.of((Object)size, (Object)acc);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal>> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<T> inputCoder) {
            return KvCoder.of((Coder)BigEndianIntegerCoder.of(), (Coder)BigDecimalCoder.of());
        }

        protected @UnknownKeyFor @NonNull @Initialized BigDecimal prepareOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> accumulator) {
            return ((BigDecimal)accumulator.getValue()).divide(new BigDecimal((Integer)accumulator.getKey()), mc);
        }

        public abstract T extractOutput(@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized BigDecimal> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized BigDecimal toBigDecimal(T var1);
    }

    private static class DropNullFnWithDefault<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends DropNullFn<InputT, AccumT, OutputT> {
        DropNullFnWithDefault(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            super(combineFn);
        }

        @Override
        public AccumT createAccumulator() {
            return (AccumT)this.combineFn.createAccumulator();
        }
    }

    private static class DropNullFn<@UnknownKeyFor InputT, @UnknownKeyFor AccumT, @UnknownKeyFor OutputT>
    extends Combine.CombineFn<InputT, AccumT, OutputT> {
        protected final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        DropNullFn(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        public AccumT createAccumulator() {
            return null;
        }

        public AccumT addInput(AccumT accumulator, InputT input) {
            if (input == null) {
                return accumulator;
            }
            if (accumulator == null) {
                accumulator = this.combineFn.createAccumulator();
            }
            return (AccumT)this.combineFn.addInput(accumulator, input);
        }

        public AccumT mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<AccumT> accumulators) {
            if (!(accumulators = Iterables.filter(accumulators, (Predicate)Predicates.notNull())).iterator().hasNext()) {
                return null;
            }
            return (AccumT)this.combineFn.mergeAccumulators(accumulators);
        }

        public OutputT extractOutput(AccumT accumulator) {
            if (accumulator == null) {
                return null;
            }
            return (OutputT)this.combineFn.extractOutput(accumulator);
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<AccumT> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            Coder coder = this.combineFn.getAccumulatorCoder(registry, inputCoder);
            if (coder instanceof NullableCoder) {
                return coder;
            }
            return NullableCoder.of((Coder)coder);
        }
    }

    static class BigDecimalSum0
    extends BigDecimalSum {
        BigDecimalSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized BigDecimal identity() {
            return BigDecimal.ZERO;
        }
    }

    static class LongSum0
    extends LongSum {
        LongSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Long identity() {
            return 0L;
        }
    }

    static class DoubleSum0
    extends DoubleSum {
        DoubleSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Double identity() {
            return 0.0;
        }
    }

    static class FloatSum0
    extends FloatSum {
        FloatSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Float identity() {
            return Float.valueOf(0.0f);
        }
    }

    static class ByteSum0
    extends ByteSum {
        ByteSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Byte identity() {
            return (byte)0;
        }
    }

    static class ShortSum0
    extends ShortSum {
        ShortSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Short identity() {
            return (short)0;
        }
    }

    static class IntegerSum0
    extends IntegerSum {
        IntegerSum0() {
        }

        public @Nullable @UnknownKeyFor @Initialized Integer identity() {
            return 0;
        }
    }

    static class BigDecimalSum
    extends Combine.BinaryCombineFn<BigDecimal> {
        BigDecimalSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized BigDecimal apply(@UnknownKeyFor @NonNull @Initialized BigDecimal left, @UnknownKeyFor @NonNull @Initialized BigDecimal right) {
            return left.add(right);
        }
    }

    static class LongSum
    extends Combine.BinaryCombineFn<Long> {
        LongSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Long apply(@UnknownKeyFor @NonNull @Initialized Long left, @UnknownKeyFor @NonNull @Initialized Long right) {
            return Math.addExact(left, right);
        }
    }

    static class DoubleSum
    extends Combine.BinaryCombineFn<Double> {
        DoubleSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Double apply(@UnknownKeyFor @NonNull @Initialized Double left, @UnknownKeyFor @NonNull @Initialized Double right) {
            return left + right;
        }
    }

    static class FloatSum
    extends Combine.BinaryCombineFn<Float> {
        FloatSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Float apply(@UnknownKeyFor @NonNull @Initialized Float left, @UnknownKeyFor @NonNull @Initialized Float right) {
            return Float.valueOf(left.floatValue() + right.floatValue());
        }
    }

    static class ByteSum
    extends Combine.BinaryCombineFn<Byte> {
        ByteSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Byte apply(@UnknownKeyFor @NonNull @Initialized Byte left, @UnknownKeyFor @NonNull @Initialized Byte right) {
            return (byte)(left + right);
        }
    }

    static class ShortSum
    extends Combine.BinaryCombineFn<Short> {
        ShortSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Short apply(@UnknownKeyFor @NonNull @Initialized Short left, @UnknownKeyFor @NonNull @Initialized Short right) {
            return (short)(left + right);
        }
    }

    static class IntegerSum
    extends Combine.BinaryCombineFn<Integer> {
        IntegerSum() {
        }

        public @UnknownKeyFor @NonNull @Initialized Integer apply(@UnknownKeyFor @NonNull @Initialized Integer left, @UnknownKeyFor @NonNull @Initialized Integer right) {
            return left + right;
        }
    }

    static class CustMin<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMin() {
        }

        public T apply(T left, T right) {
            return left == null || left.compareTo(right) < 0 ? left : right;
        }
    }

    static class CustMax<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Comparable<T>>
    extends Combine.BinaryCombineFn<T> {
        CustMax() {
        }

        public T apply(T left, T right) {
            return right == null || right.compareTo(left) < 0 ? left : right;
        }
    }
}

