/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class Schemas {
    static final @UnknownKeyFor @NonNull @Initialized String MESSAGE_KEY_FIELD = "message_key";
    static final @UnknownKeyFor @NonNull @Initialized String EVENT_TIMESTAMP_FIELD = "event_timestamp";
    static final @UnknownKeyFor @NonNull @Initialized String HEADERS_FIELD = "headers";
    static final @UnknownKeyFor @NonNull @Initialized String PAYLOAD_FIELD = "payload";
    static final @UnknownKeyFor @NonNull @Initialized String HEADERS_KEY_FIELD = "key";
    static final @UnknownKeyFor @NonNull @Initialized String HEADERS_VALUES_FIELD = "values";
    static final @UnknownKeyFor @NonNull @Initialized Schema HEADERS_ENTRY_SCHEMA = Schema.builder().addStringField("key").addArrayField("values", Schema.FieldType.BYTES).build();
    static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType HEADERS_FIELD_TYPE = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)HEADERS_ENTRY_SCHEMA));

    private Schemas() {
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNestedPayloadField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (!schema.hasField(PAYLOAD_FIELD)) {
            return false;
        }
        Schema.Field field = schema.getField(PAYLOAD_FIELD);
        if (Schemas.fieldHasType(field, Schema.FieldType.BYTES)) {
            return true;
        }
        return field.getType().getTypeName().equals((Object)Schema.TypeName.ROW);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean hasNestedHeadersField(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        if (!schema.hasField(HEADERS_FIELD)) {
            return false;
        }
        return Schemas.fieldHasType(schema.getField(HEADERS_FIELD), HEADERS_FIELD_TYPE);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isNestedSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return Schemas.hasNestedPayloadField(schema) && Schemas.hasNestedHeadersField(schema);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean fieldHasType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        return type.equivalent(field.getType(), Schema.EquivalenceNullablePolicy.WEAKEN);
    }

    private static void checkFieldHasType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType type) {
        Preconditions.checkArgument((boolean)Schemas.fieldHasType(field, type), (Object)String.format("'%s' field must have schema matching '%s'.", field.getName(), type));
    }

    static void validateNestedSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        Preconditions.checkArgument((boolean)schema.hasField(PAYLOAD_FIELD), (Object)"Must provide a 'payload' field for Kafka.");
        block12: for (Schema.Field field : schema.getFields()) {
            switch (field.getName()) {
                case "headers": {
                    Schemas.checkFieldHasType(field, HEADERS_FIELD_TYPE);
                    continue block12;
                }
                case "event_timestamp": {
                    Schemas.checkFieldHasType(field, Schema.FieldType.DATETIME);
                    continue block12;
                }
                case "message_key": {
                    Schemas.checkFieldHasType(field, Schema.FieldType.BYTES);
                    continue block12;
                }
                case "payload": {
                    Preconditions.checkArgument((Schemas.fieldHasType(field, Schema.FieldType.BYTES) || field.getType().getTypeName().equals((Object)Schema.TypeName.ROW) ? 1 : 0) != 0, (Object)String.format("'%s' field must either have a 'BYTES NOT NULL' or 'ROW' schema.", field.getName()));
                    continue block12;
                }
            }
            throw new IllegalArgumentException(String.format("'%s' field is invalid at the top level for Kafka in the nested schema.", field.getName()));
        }
    }
}

