/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamUnnestRel
extends Uncollect
implements BeamRelNode {
    private final @UnknownKeyFor @NonNull @Initialized RelDataType unnestType;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices;

    public BeamUnnestRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RelDataType unnestType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices) {
        super(cluster, traitSet, input);
        this.unnestType = unnestType;
        this.unnestIndices = unnestIndices;
    }

    public @UnknownKeyFor @NonNull @Initialized Uncollect copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        return new BeamUnnestRel(this.getCluster(), traitSet, input, this.unnestType, this.unnestIndices);
    }

    protected @UnknownKeyFor @NonNull @Initialized RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.input.getRowType(), (RelDataType)this.unnestType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, (List)ImmutableList.of());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq).multiply(2.0);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats(this, mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    public @UnknownKeyFor @NonNull @Initialized RelWriter explainTerms(@UnknownKeyFor @NonNull @Initialized RelWriter pw) {
        return super.explainTerms(pw).item("unnestIndices", this.unnestIndices);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    private static class UnnestFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices;

        private UnnestFn(@UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices) {
            this.outputSchema = outputSchema;
            this.unnestIndices = unnestIndices;
        }

        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> getNestedRowBaseValues(@UnknownKeyFor @NonNull @Initialized Row nestedRow) {
            return IntStream.range(0, nestedRow.getFieldCount()).mapToObj(i -> {
                ArrayList<Object> values = new ArrayList<Object>();
                Schema.FieldType fieldType = nestedRow.getSchema().getField(i).getType();
                if (fieldType.getTypeName().equals((Object)Schema.TypeName.ROW)) {
                    @Nullable Row row = (Row)nestedRow.getBaseValue(i, Row.class);
                    if (row == null) {
                        return Stream.builder().build();
                    }
                    List<Object> rowValues = this.getNestedRowBaseValues(row);
                    if (null != rowValues) {
                        values.addAll(rowValues);
                    }
                } else {
                    values.add(nestedRow.getBaseValue(i));
                }
                return values.stream();
            }).flatMap(Function.identity()).collect(Collectors.toList());
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
            Row rowWithArrayField = row;
            Schema schemaWithArrayField = this.outputSchema;
            for (int i = this.unnestIndices.size() - 1; i > 0; --i) {
                rowWithArrayField = rowWithArrayField.getRow(this.unnestIndices.get(i).intValue());
                schemaWithArrayField = schemaWithArrayField.getField(this.unnestIndices.get(i).intValue()).getType().getRowSchema();
            }
            @Nullable Collection rawValues = rowWithArrayField.getArray(this.unnestIndices.get(0).intValue());
            if (rawValues == null) {
                return;
            }
            Schema.TypeName typeName = schemaWithArrayField.getField(this.unnestIndices.get(0).intValue()).getType().getCollectionElementType().getTypeName();
            for (Object uncollectedValue : rawValues) {
                if (typeName.equals((Object)Schema.TypeName.ROW)) {
                    Row nestedRow = (Row)uncollectedValue;
                    out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValues(this.getNestedRowBaseValues(nestedRow)).build());
                    continue;
                }
                out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValue(uncollectedValue).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            PCollection outer = pinput.get(0);
            Schema joinedSchema = CalciteUtils.toSchema(BeamUnnestRel.this.getRowType());
            return ((PCollection)outer.apply((PTransform)ParDo.of((DoFn)new UnnestFn(joinedSchema, BeamUnnestRel.this.unnestIndices)))).setRowSchema(joinedSchema);
        }
    }
}

