/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.BeamSqlSeekableTable;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSourceRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Optional;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Join;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexFieldAccess;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Pair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class BeamJoinRel
extends Join
implements BeamRelNode {
    protected BeamJoinRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode left, @UnknownKeyFor @NonNull @Initialized RelNode right, @UnknownKeyFor @NonNull @Initialized RexNode condition, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized CorrelationId> variablesSet, @UnknownKeyFor @NonNull @Initialized JoinRelType joinType) {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> getPCollectionInputs() {
        if (this.isSideInputLookupJoin()) {
            return ImmutableList.of((Object)BeamSqlRelUtils.getBeamRelInput((RelNode)this.getInputs().get((Integer)this.nonSeekableInputIndex().get())));
        }
        return BeamRelNode.super.getPCollectionInputs();
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean isSideInputLookupJoin() {
        return this.seekableInputIndex().isPresent() && this.nonSeekableInputIndex().isPresent();
    }

    protected @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Integer> seekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return BeamJoinRel.seekable(leftRelNode) ? Optional.of((Object)0) : (BeamJoinRel.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    protected @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Integer> nonSeekableInputIndex() {
        BeamRelNode leftRelNode = BeamSqlRelUtils.getBeamRelInput(this.left);
        BeamRelNode rightRelNode = BeamSqlRelUtils.getBeamRelInput(this.right);
        return !BeamJoinRel.seekable(leftRelNode) ? Optional.of((Object)0) : (!BeamJoinRel.seekable(rightRelNode) ? Optional.of((Object)1) : Optional.absent());
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean seekable(@UnknownKeyFor @NonNull @Initialized BeamRelNode relNode) {
        BeamIOSourceRel srcRel;
        BeamSqlTable sourceTable;
        return relNode instanceof BeamIOSourceRel && (sourceTable = (srcRel = (BeamIOSourceRel)relNode).getBeamSqlTable()) instanceof BeamSqlSeekableTable;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats leftEstimates = BeamSqlRelUtils.getNodeStats(this.left, mq);
        NodeStats rightEstimates = BeamSqlRelUtils.getNodeStats(this.right, mq);
        NodeStats selfEstimates = BeamSqlRelUtils.getNodeStats(this, mq);
        NodeStats summation = selfEstimates.plus(leftEstimates).plus(rightEstimates);
        return BeamCostModel.FACTORY.makeCost(summation.getRowCount(), summation.getRate());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        double selectivity = (Double)Preconditions.checkArgumentNotNull((Object)mq.getSelectivity(this, this.getCondition()), (String)"Attempted to estimate node stats for BeamJoinRel '%s', but selectivity is null.", (Object)this);
        NodeStats leftEstimates = BeamSqlRelUtils.getNodeStats(this.left, mq);
        NodeStats rightEstimates = BeamSqlRelUtils.getNodeStats(this.right, mq);
        if (leftEstimates.isUnknown() || rightEstimates.isUnknown()) {
            return NodeStats.UNKNOWN;
        }
        return NodeStats.create(leftEstimates.getRowCount() * rightEstimates.getRowCount() * selectivity, (leftEstimates.getRate() * rightEstimates.getWindow() + rightEstimates.getRate() * leftEstimates.getWindow()) * selectivity, leftEstimates.getWindow() * rightEstimates.getWindow() * selectivity);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isJoinLegal(@UnknownKeyFor @NonNull @Initialized Join join) {
        try {
            BeamJoinRel.extractJoinRexNodes(join.getCondition());
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized RexNode, @UnknownKeyFor @NonNull @Initialized RexNode>> extractJoinRexNodes(@UnknownKeyFor @NonNull @Initialized RexNode condition) {
        if (condition instanceof RexLiteral) {
            throw new UnsupportedOperationException("CROSS JOIN, JOIN ON FALSE is not supported!");
        }
        RexCall call = (RexCall)condition;
        ArrayList<Pair<RexNode, RexNode>> pairs = new ArrayList<Pair<RexNode, RexNode>>();
        if ("AND".equals(call.getOperator().getName())) {
            List operands = call.getOperands();
            for (RexNode rexNode : operands) {
                Pair<RexNode, RexNode> pair = BeamJoinRel.extractJoinPairOfRexNodes((RexCall)rexNode);
                pairs.add(pair);
            }
        } else if ("=".equals(call.getOperator().getName())) {
            pairs.add(BeamJoinRel.extractJoinPairOfRexNodes(call));
        } else {
            throw new UnsupportedOperationException("Operator " + call.getOperator().getName() + " is not supported in join condition");
        }
        return pairs;
    }

    private static @UnknownKeyFor @NonNull @Initialized Pair<@UnknownKeyFor @NonNull @Initialized RexNode, @UnknownKeyFor @NonNull @Initialized RexNode> extractJoinPairOfRexNodes(@UnknownKeyFor @NonNull @Initialized RexCall rexCall) {
        int rightIndex;
        if (!rexCall.getOperator().getName().equals("=")) {
            throw new UnsupportedOperationException("Non equi-join is not supported");
        }
        if (BeamJoinRel.isIllegalJoinConjunctionClause(rexCall)) {
            throw new UnsupportedOperationException("Only support column reference or struct field access in conjunction clause");
        }
        int leftIndex = BeamJoinRel.getColumnIndex((RexNode)rexCall.getOperands().get(0));
        if (leftIndex < (rightIndex = BeamJoinRel.getColumnIndex((RexNode)rexCall.getOperands().get(1)))) {
            return new Pair((Object)((RexNode)rexCall.getOperands().get(0)), (Object)((RexNode)rexCall.getOperands().get(1)));
        }
        return new Pair((Object)((RexNode)rexCall.getOperands().get(1)), (Object)((RexNode)rexCall.getOperands().get(0)));
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIllegalJoinConjunctionClause(@UnknownKeyFor @NonNull @Initialized RexCall rexCall) {
        return !(rexCall.getOperands().get(0) instanceof RexInputRef) && !(rexCall.getOperands().get(0) instanceof RexFieldAccess) || !(rexCall.getOperands().get(1) instanceof RexInputRef) && !(rexCall.getOperands().get(1) instanceof RexFieldAccess);
    }

    private static @UnknownKeyFor @NonNull @Initialized int getColumnIndex(@UnknownKeyFor @NonNull @Initialized RexNode rexNode) {
        if (rexNode instanceof RexInputRef) {
            return ((RexInputRef)rexNode).getIndex();
        }
        if (rexNode instanceof RexFieldAccess) {
            return BeamJoinRel.getColumnIndex(((RexFieldAccess)rexNode).getReferenceExpr());
        }
        throw new UnsupportedOperationException("Cannot get column index from " + rexNode.getType());
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded getBoundednessOfRelNode(@UnknownKeyFor @NonNull @Initialized RelNode relNode) {
        if (relNode instanceof BeamRelNode) {
            return ((BeamRelNode)relNode).isBounded();
        }
        ArrayList<PCollection.IsBounded> boundednessOfInputs = new ArrayList<PCollection.IsBounded>();
        for (RelNode inputRel : relNode.getInputs()) {
            if (inputRel instanceof RelSubset) {
                RelNode rel = ((RelSubset)inputRel).getBest();
                if (rel == null) {
                    rel = (RelNode)((RelSubset)inputRel).getRelList().get(0);
                }
                boundednessOfInputs.add(BeamJoinRel.getBoundednessOfRelNode(rel));
                continue;
            }
            boundednessOfInputs.add(BeamJoinRel.getBoundednessOfRelNode(inputRel));
        }
        return boundednessOfInputs.contains(PCollection.IsBounded.UNBOUNDED) ? PCollection.IsBounded.UNBOUNDED : PCollection.IsBounded.BOUNDED;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean containsSeekableInput(@UnknownKeyFor @NonNull @Initialized RelNode relNode) {
        for (RelNode relInput : relNode.getInputs()) {
            if (relInput instanceof RelSubset) {
                relInput = ((RelSubset)relInput).getBest();
            }
            if (relInput == null || !(relInput instanceof BeamRelNode) || !BeamJoinRel.seekable((BeamRelNode)relInput)) continue;
            return true;
        }
        return false;
    }
}

