/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.TableResolutionUtils;
import org.apache.beam.sdk.extensions.sql.impl.UdfImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.RelMdNodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.udf.BeamBuiltinFunctionProvider;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.Table;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.Contexts;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParseException;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Planner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.ValidationException;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteQueryPlanner
implements QueryPlanner {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CalciteQueryPlanner.class);
    private final @UnknownKeyFor @NonNull @Initialized Planner planner;
    private final @UnknownKeyFor @NonNull @Initialized JdbcConnection connection;
    public static final @UnknownKeyFor @NonNull @Initialized QueryPlanner.Factory FACTORY = new QueryPlanner.Factory(){

        @Override
        public @UnknownKeyFor @NonNull @Initialized QueryPlanner createPlanner(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
            this.loadBuiltinFunctions(jdbcConnection);
            return new CalciteQueryPlanner(jdbcConnection, ruleSets);
        }

        private void loadBuiltinFunctions(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection) {
            for (BeamBuiltinFunctionProvider provider : ServiceLoader.load(BeamBuiltinFunctionProvider.class)) {
                for (Map.Entry<String, List<Method>> entry : provider.getBuiltinMethods().entrySet()) {
                    for (Method method : entry.getValue()) {
                        jdbcConnection.getCurrentSchemaPlus().add(entry.getKey(), UdfImpl.create(method));
                    }
                }
            }
        }
    };

    public CalciteQueryPlanner(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
        this.connection = connection;
        this.planner = Frameworks.getPlanner((FrameworkConfig)this.defaultConfig(connection, ruleSets));
    }

    public @UnknownKeyFor @NonNull @Initialized FrameworkConfig defaultConfig(@UnknownKeyFor @NonNull @Initialized JdbcConnection connection, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized RuleSet> ruleSets) {
        CalciteConnectionConfig config = connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = (SqlParserImplFactory)config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = connection.getRootSchema();
        SchemaPlus defaultSchema = connection.getCurrentSchemaPlus();
        ImmutableList traitDefs = ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schema), (List)ImmutableList.of((Object)defaultSchema.getName()), (RelDataTypeFactory)connection.getTypeFactory(), connection.config());
        SqlOperatorTable opTab0 = (SqlOperatorTable)connection.config().fun(SqlOperatorTable.class, (Object)SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List)traitDefs).context(Contexts.of((Object)connection.config())).ruleSets(ruleSets.toArray(new RuleSet[0])).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(connection.getTypeFactory().getTypeSystem()).operatorTable(SqlOperatorTables.chain((SqlOperatorTable[])new SqlOperatorTable[]{opTab0, catalogReader})).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SqlNode parse(@UnknownKeyFor @NonNull @Initialized String sqlStatement) throws @UnknownKeyFor @NonNull @Initialized ParseException {
        SqlNode parsed;
        try {
            parsed = this.planner.parse(sqlStatement);
        }
        catch (SqlParseException e) {
            throw new ParseException(String.format("Unable to parse query %s", sqlStatement), e);
        }
        finally {
            this.planner.close();
        }
        return parsed;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamRelNode convertToBeamRel(@UnknownKeyFor @NonNull @Initialized String sqlStatement, @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParameters) throws @UnknownKeyFor @NonNull @Initialized ParseException, @UnknownKeyFor @NonNull @Initialized SqlConversionException {
        BeamRelNode beamRelNode;
        Preconditions.checkArgument((queryParameters.getKind() == QueryPlanner.QueryParameters.Kind.NONE ? 1 : 0) != 0, (Object)"Beam SQL Calcite dialect does not yet support query parameters.");
        try {
            SqlNode parsed = this.planner.parse(sqlStatement);
            TableResolutionUtils.setupCustomTableResolution(this.connection, parsed);
            SqlNode validated = this.planner.validate(parsed);
            LOG.info("SQL:\n" + validated);
            RelRoot root = this.planner.rel(validated);
            LOG.info("SQLPlan>\n" + RelOptUtil.toString((RelNode)root.rel));
            RelTraitSet desiredTraits = root.rel.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
            root.rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)NonCumulativeCostImpl.SOURCE, (Object)RelMdNodeStats.SOURCE, (Object)root.rel.getCluster().getMetadataProvider())));
            root.rel.getCluster().setMetadataQuerySupplier(BeamRelMetadataQuery::instance);
            RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)root.rel.getCluster().getMetadataProvider()));
            root.rel.getCluster().invalidateMetadataQuery();
            beamRelNode = (BeamRelNode)this.planner.transform(0, desiredTraits, root.rel);
            LOG.info("BEAMPlan>\n" + RelOptUtil.toString((RelNode)beamRelNode));
        }
        catch (RelOptPlanner.CannotPlanException | RelConversionException e) {
            throw new SqlConversionException(String.format("Unable to convert query %s", sqlStatement), e);
        }
        catch (SqlParseException | ValidationException e) {
            throw new ParseException(String.format("Unable to parse query %s", sqlStatement), e);
        }
        finally {
            this.planner.close();
        }
        return beamRelNode;
    }

    public static class NonCumulativeCostImpl
    implements MetadataHandler<BuiltInMetadata.NonCumulativeCost> {
        public static final @UnknownKeyFor @NonNull @Initialized RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.NON_CUMULATIVE_COST.method, (MetadataHandler)new NonCumulativeCostImpl());

        public @UnknownKeyFor @NonNull @Initialized MetadataDef<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized BuiltInMetadata.NonCumulativeCost> getDef() {
            return BuiltInMetadata.NonCumulativeCost.DEF;
        }

        public @UnknownKeyFor @NonNull @Initialized RelOptCost getNonCumulativeCost(@UnknownKeyFor @NonNull @Initialized RelNode rel, @UnknownKeyFor @NonNull @Initialized RelMetadataQuery mq) {
            assert (mq instanceof BeamRelMetadataQuery);
            BeamRelMetadataQuery bmq = (BeamRelMetadataQuery)mq;
            if (!(rel instanceof BeamRelNode)) {
                return rel.computeSelfCost(rel.getCluster().getPlanner(), (RelMetadataQuery)bmq);
            }
            List<Table.Cell> costKeys = bmq.map.cellSet().stream().filter(entry -> entry.getValue() instanceof BeamCostModel).filter(entry -> ((BeamCostModel)entry.getValue()).isInfinite()).collect(Collectors.toList());
            costKeys.forEach(cell -> bmq.map.remove(cell.getRowKey(), cell.getColumnKey()));
            return ((BeamRelNode)rel).beamComputeSelfCost(rel.getCluster().getPlanner(), bmq);
        }
    }
}

