/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.pubsublite;

import com.google.cloud.pubsublite.proto.AttributeValues;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.transforms.Cast;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.joda.time.ReadableDateTime;

class RowHandler
implements Serializable {
    private static final long serialVersionUID = 6827681678454156L;
    static final String PUBLISH_TIMESTAMP_FIELD = "publish_timestamp";
    static final String MESSAGE_KEY_FIELD = "message_key";
    static final String EVENT_TIMESTAMP_FIELD = "event_timestamp";
    static final String ATTRIBUTES_FIELD = "attributes";
    static final String PAYLOAD_FIELD = "payload";
    static final String ATTRIBUTES_KEY_FIELD = "key";
    static final String ATTRIBUTES_VALUES_FIELD = "values";
    static final Schema ATTRIBUTES_ENTRY_SCHEMA = Schema.builder().addStringField("key").addArrayField("values", Schema.FieldType.BYTES).build();
    static final Schema.FieldType ATTRIBUTES_FIELD_TYPE = Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)ATTRIBUTES_ENTRY_SCHEMA));
    private final Schema schema;
    @Nullable
    private final PayloadSerializer payloadSerializer;

    RowHandler(Schema schema) {
        Preconditions.checkArgument((boolean)schema.getField(PAYLOAD_FIELD).getType().equals((Object)Schema.FieldType.BYTES));
        this.schema = schema;
        this.payloadSerializer = null;
    }

    RowHandler(Schema schema, @Nonnull PayloadSerializer payloadSerializer) {
        this.schema = schema;
        this.payloadSerializer = payloadSerializer;
        Preconditions.checkArgument((boolean)schema.getField(PAYLOAD_FIELD).getType().getTypeName().equals((Object)Schema.TypeName.ROW));
    }

    Row messageToRow(SequencedMessage message) {
        Row.FieldValueBuilder builder = Row.withSchema((Schema)this.schema).withFieldValues((Map)ImmutableMap.of());
        if (this.schema.hasField(PUBLISH_TIMESTAMP_FIELD)) {
            builder.withFieldValue(PUBLISH_TIMESTAMP_FIELD, (Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)message.getPublishTime())));
        }
        if (this.schema.hasField(MESSAGE_KEY_FIELD)) {
            builder.withFieldValue(MESSAGE_KEY_FIELD, (Object)message.getMessage().getKey().toByteArray());
        }
        if (this.schema.hasField(EVENT_TIMESTAMP_FIELD) && message.getMessage().hasEventTime()) {
            builder.withFieldValue(EVENT_TIMESTAMP_FIELD, (Object)Instant.ofEpochMilli((long)Timestamps.toMillis((Timestamp)message.getMessage().getEventTime())));
        }
        if (this.schema.hasField(ATTRIBUTES_FIELD)) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            message.getMessage().getAttributesMap().forEach((key, values) -> {
                Row entry = Row.withSchema((Schema)ATTRIBUTES_ENTRY_SCHEMA).withFieldValue(ATTRIBUTES_KEY_FIELD, key).withFieldValue(ATTRIBUTES_VALUES_FIELD, values.getValuesList().stream().map(ByteString::toByteArray).collect(Collectors.toList())).build();
                listBuilder.add((Object)entry);
            });
            builder.withFieldValue(ATTRIBUTES_FIELD, (Object)listBuilder.build());
        }
        if (this.payloadSerializer == null) {
            builder.withFieldValue(PAYLOAD_FIELD, (Object)message.getMessage().getData().toByteArray());
        } else {
            builder.withFieldValue(PAYLOAD_FIELD, (Object)this.payloadSerializer.deserialize(message.getMessage().getData().toByteArray()));
        }
        return builder.build();
    }

    PubSubMessage rowToMessage(Row row) {
        Object payload;
        Collection attributes;
        ReadableDateTime time;
        byte[] bytes;
        row = Cast.castRow((Row)row, (Schema)row.getSchema(), (Schema)this.schema);
        PubSubMessage.Builder builder = PubSubMessage.newBuilder();
        if (this.schema.hasField(MESSAGE_KEY_FIELD) && (bytes = row.getBytes(MESSAGE_KEY_FIELD)) != null) {
            builder.setKey(ByteString.copyFrom((byte[])bytes));
        }
        if (this.schema.hasField(EVENT_TIMESTAMP_FIELD) && (time = row.getDateTime(EVENT_TIMESTAMP_FIELD)) != null) {
            builder.setEventTime(Timestamps.fromMillis((long)time.getMillis()));
        }
        if (this.schema.hasField(ATTRIBUTES_FIELD) && (attributes = row.getArray(ATTRIBUTES_FIELD)) != null) {
            attributes.forEach(entry -> {
                AttributeValues.Builder valuesBuilder = AttributeValues.newBuilder();
                Collection values = (Collection)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)entry.getArray(ATTRIBUTES_VALUES_FIELD));
                values.forEach(bytes -> valuesBuilder.addValues(ByteString.copyFrom((byte[])bytes)));
                builder.putAttributes((String)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)entry.getString(ATTRIBUTES_KEY_FIELD)), valuesBuilder.build());
            });
        }
        if (this.payloadSerializer == null) {
            payload = row.getBytes(PAYLOAD_FIELD);
            if (payload != null) {
                builder.setData(ByteString.copyFrom((byte[])payload));
            }
        } else {
            payload = row.getRow(PAYLOAD_FIELD);
            if (payload != null) {
                builder.setData(ByteString.copyFrom((byte[])this.payloadSerializer.serialize((Row)payload)));
            }
        }
        return builder.build();
    }
}

