/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlCollation;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Static;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Util;

public class NlsString
implements Comparable<NlsString>,
Cloneable {
    private final String charsetName;
    private final String value;
    private final Charset charset;
    private final SqlCollation collation;

    public NlsString(String value, String charsetName, SqlCollation collation) {
        assert (value != null);
        if (null != charsetName) {
            this.charsetName = charsetName = charsetName.toUpperCase(Locale.ROOT);
            String javaCharsetName = SqlUtil.translateCharacterSetName(charsetName);
            if (javaCharsetName == null) {
                throw new UnsupportedCharsetException(charsetName);
            }
            this.charset = Charset.forName(javaCharsetName);
            CharsetEncoder encoder = this.charset.newEncoder();
            try {
                encoder.encode(CharBuffer.wrap(value));
            }
            catch (CharacterCodingException ex) {
                throw Static.RESOURCE.charsetEncoding(value, javaCharsetName).ex();
            }
        } else {
            this.charsetName = null;
            this.charset = null;
        }
        this.collation = collation;
        this.value = value;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        return Objects.hash(this.value, this.charsetName, this.collation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsString)) {
            return false;
        }
        NlsString that = (NlsString)obj;
        return Objects.equals(this.value, that.value) && Objects.equals(this.charsetName, that.charsetName) && Objects.equals(this.collation, that.collation);
    }

    @Override
    public int compareTo(NlsString other) {
        return this.value.compareTo(other.value);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getValue() {
        return this.value;
    }

    public NlsString rtrim() {
        String trimmed = SqlFunctions.rtrim(this.value);
        if (!trimmed.equals(this.value)) {
            return new NlsString(trimmed, this.charsetName, this.collation);
        }
        return this;
    }

    public String asSql(boolean prefix, boolean suffix) {
        StringBuilder ret = new StringBuilder();
        if (prefix && null != this.charsetName) {
            ret.append("_");
            ret.append(this.charsetName);
        }
        ret.append("'");
        ret.append(Util.replace(this.value, "'", "''"));
        ret.append("'");
        return ret.toString();
    }

    public String toString() {
        return this.asSql(true, true);
    }

    public static NlsString concat(List<NlsString> args) {
        if (args.size() < 2) {
            return args.get(0);
        }
        String charSetName = args.get((int)0).charsetName;
        SqlCollation collation = args.get((int)0).collation;
        int length = args.get((int)0).value.length();
        for (int i = 1; i < args.size(); ++i) {
            NlsString arg = args.get(i);
            length += arg.value.length();
            if (arg.charsetName != null && !arg.charsetName.equals(charSetName)) {
                throw new IllegalArgumentException("mismatched charsets");
            }
            if (arg.collation == null || arg.collation.equals(collation)) continue;
            throw new IllegalArgumentException("mismatched collations");
        }
        StringBuilder sb = new StringBuilder(length);
        for (NlsString arg : args) {
            sb.append(arg.value);
        }
        return new NlsString(sb.toString(), charSetName, collation);
    }

    public NlsString copy(String value) {
        return new NlsString(value, this.charsetName, this.collation);
    }
}

