/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.util.SqlVisitor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.Litmus;

public class SqlNodeList
extends SqlNode
implements Iterable<SqlNode> {
    public static final SqlNodeList EMPTY = new SqlNodeList(SqlParserPos.ZERO){

        @Override
        public void add(SqlNode node) {
            throw new UnsupportedOperationException();
        }
    };
    private final List<SqlNode> list;

    public SqlNodeList(SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>();
    }

    public SqlNodeList(Collection<? extends SqlNode> collection, SqlParserPos pos) {
        super(pos);
        this.list = new ArrayList<SqlNode>(collection);
    }

    @Override
    public Iterator<SqlNode> iterator() {
        return this.list.iterator();
    }

    public List<SqlNode> getList() {
        return this.list;
    }

    public void add(SqlNode node) {
        this.list.add(node);
    }

    @Override
    public SqlNodeList clone(SqlParserPos pos) {
        return new SqlNodeList(this.list, pos);
    }

    public SqlNode get(int n) {
        return this.list.get(n);
    }

    public SqlNode set(int n, SqlNode node) {
        return this.list.set(n, node);
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = leftPrec > 0 || rightPrec > 0 ? writer.startList("(", ")") : writer.startList("", "");
        this.commaList(writer);
        writer.endList(frame);
    }

    void commaList(SqlWriter writer) {
        for (SqlNode node : this.list) {
            writer.sep(",");
            node.unparse(writer, 2, 3);
        }
    }

    void andOrList(SqlWriter writer, SqlKind sepKind) {
        SqlBinaryOperator sepOp = sepKind == SqlKind.AND ? SqlStdOperatorTable.AND : SqlStdOperatorTable.OR;
        for (int i = 0; i < this.list.size(); ++i) {
            SqlNode node = this.list.get(i);
            writer.sep(sepKind.name(), false);
            int lprec = i == 0 ? 0 : sepOp.getRightPrec();
            int rprec = i == this.list.size() - 1 ? 0 : sepOp.getLeftPrec();
            node.unparse(writer, lprec, rprec);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode child : this.list) {
            child.validate(validator, scope);
        }
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlNodeList)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlNodeList that = (SqlNodeList)node;
        if (this.size() != that.size()) {
            return litmus.fail("{} != {}", this, node);
        }
        for (int i = 0; i < this.list.size(); ++i) {
            SqlNode thatChild;
            SqlNode thisChild = this.list.get(i);
            if (thisChild.equalsDeep(thatChild = that.list.get(i), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public SqlNode[] toArray() {
        return this.list.toArray(new SqlNode[this.list.size()]);
    }

    public static boolean isEmptyList(SqlNode node) {
        return node instanceof SqlNodeList && 0 == ((SqlNodeList)node).size();
    }

    public static SqlNodeList of(SqlNode node1) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        return list;
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        list.add(node2);
        return list;
    }

    public static SqlNodeList of(SqlNode node1, SqlNode node2, SqlNode ... nodes) {
        SqlNodeList list = new SqlNodeList(SqlParserPos.ZERO);
        list.add(node1);
        list.add(node2);
        for (SqlNode node : nodes) {
            list.add(node);
        }
        return list;
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        for (SqlNode node : this.list) {
            node.validateExpr(validator, scope);
        }
    }
}

