/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.impl;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.ImmutableList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.QueryProvider;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.Queryable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelRoot;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.Schema;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.TranslatableTable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.schema.impl.ViewTableMacro;

public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;
    private final List<String> viewPath;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, List<String> viewPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
        this.viewPath = viewPath == null ? null : ImmutableList.copyOf(viewPath);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, Boolean.TRUE);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, Boolean modifiable) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, modifiable);
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, List<String> viewPath, Boolean modifiable) {
        return new ViewTableMacro(CalciteSchema.from(schema), viewSql, schemaPath, viewPath, modifiable);
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public List<String> getViewPath() {
        return this.viewPath;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView((RelOptTable.ToRelContext)context, (RelDataType)relOptTable.getRowType(), (String)this.viewSql).rel;
    }

    private RelRoot expandView(RelOptTable.ToRelContext preparingStmt, RelDataType rowType, String queryString) {
        try {
            RelRoot root = preparingStmt.expandView(rowType, queryString, this.schemaPath, this.viewPath);
            root = root.withRel(RelOptUtil.createCastRel(root.rel, rowType, true));
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing view definition: " + queryString, e);
        }
    }
}

