/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import org.apache.beam.sdks.java.extensions.sql.repackaged.com.google.common.collect.Lists;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.RelNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.Join;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexNode;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.rex.RexUtil;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.util.mapping.Mappings;

public class JoinAssociateRule
extends RelOptRule {
    public static final JoinAssociateRule INSTANCE = new JoinAssociateRule(RelFactories.LOGICAL_BUILDER);

    public JoinAssociateRule(RelBuilderFactory relBuilderFactory) {
        super(JoinAssociateRule.operand(Join.class, JoinAssociateRule.operand(Join.class, JoinAssociateRule.any()), JoinAssociateRule.operand(RelSubset.class, JoinAssociateRule.any())), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelSubset relC = (RelSubset)call.rel(2);
        RelOptCluster cluster = topJoin.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (relC.getConvention() != relA.getConvention()) {
            return;
        }
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet aBitSet = ImmutableBitSet.range(0, aCount);
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (!topJoin.getSystemFieldList().isEmpty()) {
            return;
        }
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> top = Lists.newArrayList();
        ArrayList<RexNode> bottom = Lists.newArrayList();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), aBitSet, top, bottom);
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, top, bottom);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, aCount, bCount, bCount, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = Lists.newArrayList();
        new RexPermuteInputsShuttle(bottomMapping, relB, relC).visitList(bottom, newBottomList);
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relB, relC, JoinRelType.INNER, false);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, top, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, relA, newBottomJoin, JoinRelType.INNER, false);
        call.transformTo(newTopJoin);
    }
}

