/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ConditionalStatement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Node;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Primitive;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Statement;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.TernaryExpression;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.Types;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.apache.calcite.linq4j.tree.UnaryExpression;

public class OptimizeShuttle
extends Shuttle {
    public static final ConstantExpression FALSE_EXPR = Expressions.constant(false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant(true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, "FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, "TRUE");
    public static final Statement EMPTY_STATEMENT = Expressions.statement(null);
    private static final Set<Method> KNOWN_NON_NULL_METHODS = new HashSet<Method>();
    private static final Map<ExpressionType, ExpressionType> NOT_BINARY_COMPLEMENT;
    private static final Method BOOLEAN_VALUEOF_BOOL;

    private static void addComplement(ExpressionType eq, ExpressionType ne) {
        NOT_BINARY_COMPLEMENT.put(eq, ne);
        NOT_BINARY_COMPLEMENT.put(ne, eq);
    }

    @Override
    public Expression visit(TernaryExpression ternary, Expression expression0, Expression expression1, Expression expression2) {
        switch (ternary.getNodeType()) {
            case Conditional: {
                UnaryExpression una;
                Boolean always = OptimizeShuttle.always(expression0);
                if (always != null) {
                    return always != false ? expression1 : expression2;
                }
                if (expression1.equals(expression2)) {
                    return expression1;
                }
                if (expression0 instanceof UnaryExpression && (una = (UnaryExpression)expression0).getNodeType() == ExpressionType.Not) {
                    return Expressions.makeTernary(ternary.getNodeType(), una.expression, expression2, expression1);
                }
                always = OptimizeShuttle.always(expression1);
                if (always != null && this.isKnownNotNull(expression2)) {
                    return (always != false ? Expressions.orElse(expression0, expression2) : Expressions.andAlso(Expressions.not(expression0), expression2)).accept(this);
                }
                always = OptimizeShuttle.always(expression2);
                if (always != null && this.isKnownNotNull(expression1)) {
                    return (always != false ? Expressions.orElse(Expressions.not(expression0), expression1) : Expressions.andAlso(expression0, expression1)).accept(this);
                }
                if (!(expression0 instanceof BinaryExpression) || expression0.getNodeType() != ExpressionType.Equal && expression0.getNodeType() != ExpressionType.NotEqual) break;
                BinaryExpression cmp = (BinaryExpression)expression0;
                Expression expr = null;
                if (OptimizeShuttle.eq(cmp.expression0, expression2) && OptimizeShuttle.eq(cmp.expression1, expression1)) {
                    Expression expression = expr = expression0.getNodeType() == ExpressionType.Equal ? expression2 : expression1;
                }
                if (OptimizeShuttle.eq(cmp.expression0, expression1) && OptimizeShuttle.eq(cmp.expression1, expression2)) {
                    Expression expression = expr = expression0.getNodeType() == ExpressionType.Equal ? expression2 : expression1;
                }
                if (expr == null) break;
                return expr;
            }
        }
        return super.visit(ternary, expression0, expression1, expression2);
    }

    @Override
    public Expression visit(BinaryExpression binary, Expression expression0, Expression expression1) {
        switch (binary.getNodeType()) {
            case AndAlso: 
            case OrElse: {
                if (!OptimizeShuttle.eq(expression0, expression1)) break;
                return expression0;
            }
        }
        switch (binary.getNodeType()) {
            case Equal: 
            case NotEqual: {
                if (OptimizeShuttle.eq(expression0, expression1)) {
                    return binary.getNodeType() == ExpressionType.Equal ? TRUE_EXPR : FALSE_EXPR;
                }
                if (expression0 instanceof ConstantExpression && expression1 instanceof ConstantExpression) {
                    ConstantExpression c0 = (ConstantExpression)expression0;
                    ConstantExpression c1 = (ConstantExpression)expression1;
                    if (c0.getType() == c1.getType() || !Primitive.is(c0.getType()) && !Primitive.is(c1.getType())) {
                        return binary.getNodeType() == ExpressionType.NotEqual ? TRUE_EXPR : FALSE_EXPR;
                    }
                }
                if (expression0 instanceof TernaryExpression && expression0.getNodeType() == ExpressionType.Conditional) {
                    TernaryExpression ternary = (TernaryExpression)expression0;
                    Expression expr = null;
                    if (OptimizeShuttle.eq(ternary.expression1, expression1)) {
                        expr = Expressions.orElse(ternary.expression0, Expressions.equal(ternary.expression2, expression1));
                    } else if (OptimizeShuttle.eq(ternary.expression2, expression1)) {
                        expr = Expressions.orElse(Expressions.not(ternary.expression0), Expressions.equal(ternary.expression1, expression1));
                    }
                    if (expr != null) {
                        if (binary.getNodeType() == ExpressionType.NotEqual) {
                            expr = Expressions.not(expr);
                        }
                        return ((Expression)expr).accept(this);
                    }
                }
            }
            case AndAlso: 
            case OrElse: {
                Expression result = this.visit0(binary, expression0, expression1);
                if (result != null) {
                    return result;
                }
                result = this.visit0(binary, expression1, expression0);
                if (result == null) break;
                return result;
            }
        }
        return super.visit(binary, expression0, expression1);
    }

    private Expression visit0(BinaryExpression binary, Expression expression0, Expression expression1) {
        switch (binary.getNodeType()) {
            case AndAlso: {
                Boolean always = OptimizeShuttle.always(expression0);
                if (always == null) break;
                return always != false ? expression1 : FALSE_EXPR;
            }
            case OrElse: {
                Boolean always = OptimizeShuttle.always(expression0);
                if (always == null) break;
                return always != false ? TRUE_EXPR : expression1;
            }
            case Equal: {
                if (this.isConstantNull(expression1) && Primitive.is(expression0.getType())) {
                    return FALSE_EXPR;
                }
                Boolean always = OptimizeShuttle.always(expression0);
                if (always == null) break;
                return always != false ? expression1 : Expressions.not(expression1);
            }
            case NotEqual: {
                if (this.isConstantNull(expression1) && Primitive.is(expression0.getType())) {
                    return TRUE_EXPR;
                }
                Boolean always = OptimizeShuttle.always(expression0);
                if (always == null) break;
                return always != false ? Expressions.not(expression1) : expression1;
            }
        }
        return null;
    }

    @Override
    public Expression visit(UnaryExpression unaryExpression, Expression expression) {
        switch (unaryExpression.getNodeType()) {
            case Convert: {
                if (expression.getType() == unaryExpression.getType()) {
                    return expression;
                }
                if (!(expression instanceof ConstantExpression)) break;
                return Expressions.constant(((ConstantExpression)expression).value, unaryExpression.getType());
            }
            case Not: {
                BinaryExpression bin;
                ExpressionType comp;
                UnaryExpression arg;
                Boolean always = OptimizeShuttle.always(expression);
                if (always != null) {
                    return always != false ? FALSE_EXPR : TRUE_EXPR;
                }
                if (expression instanceof UnaryExpression && (arg = (UnaryExpression)expression).getNodeType() == ExpressionType.Not) {
                    return arg.expression;
                }
                if (!(expression instanceof BinaryExpression) || (comp = NOT_BINARY_COMPLEMENT.get((Object)(bin = (BinaryExpression)expression).getNodeType())) == null) break;
                return Expressions.makeBinary(comp, bin.expression0, bin.expression1);
            }
        }
        return super.visit(unaryExpression, expression);
    }

    @Override
    public Statement visit(ConditionalStatement conditionalStatement, List<Node> list) {
        boolean optimal = true;
        for (int i = 0; i < list.size() - 1 && optimal; i += 2) {
            Boolean always = OptimizeShuttle.always((Expression)list.get(i));
            if (always == null) continue;
            if (i == 0 && always.booleanValue()) {
                return (Statement)list.get(1);
            }
            optimal = false;
        }
        if (optimal) {
            return super.visit(conditionalStatement, list);
        }
        ArrayList<Node> newList = new ArrayList<Node>(list.size());
        for (int i = 0; i < list.size() - 1; i += 2) {
            Expression test = (Expression)list.get(i);
            Node stmt = list.get(i + 1);
            Boolean always = OptimizeShuttle.always(test);
            if (always == null) {
                newList.add(test);
                newList.add(stmt);
                continue;
            }
            if (!always.booleanValue()) continue;
            newList.add(stmt);
            break;
        }
        if (list.size() == 1) {
            return (Statement)list.get(0);
        }
        if (newList.size() % 2 == 0 && list.size() % 2 == 1) {
            Node elseBlock = list.get(list.size() - 1);
            if (newList.isEmpty()) {
                return (Statement)elseBlock;
            }
            newList.add(elseBlock);
        }
        if (newList.isEmpty()) {
            return EMPTY_STATEMENT;
        }
        return super.visit(conditionalStatement, newList);
    }

    @Override
    public Expression visit(MethodCallExpression methodCallExpression, Expression targetExpression, List<Expression> expressions) {
        Boolean always;
        if (BOOLEAN_VALUEOF_BOOL.equals(methodCallExpression.method) && (always = OptimizeShuttle.always(expressions.get(0))) != null) {
            return always != false ? TRUE_EXPR : FALSE_EXPR;
        }
        return super.visit(methodCallExpression, targetExpression, expressions);
    }

    private boolean isConstantNull(Expression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).value == null;
    }

    private static Boolean always(Expression x) {
        if (x.equals(FALSE_EXPR) || x.equals(BOXED_FALSE_EXPR)) {
            return Boolean.FALSE;
        }
        if (x.equals(TRUE_EXPR) || x.equals(BOXED_TRUE_EXPR)) {
            return Boolean.TRUE;
        }
        return null;
    }

    protected boolean isKnownNotNull(Expression expression) {
        return Primitive.is(expression.getType()) || OptimizeShuttle.always(expression) != null || expression instanceof MethodCallExpression && KNOWN_NON_NULL_METHODS.contains(((MethodCallExpression)expression).method);
    }

    private static boolean eq(Expression a, Expression b) {
        return a.equals(b) || a instanceof ConstantExpression && b instanceof ConstantExpression && ((ConstantExpression)a).value == ((ConstantExpression)b).value;
    }

    static {
        for (Class aClass : new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, String.class}) {
            for (Method method : aClass.getMethods()) {
                if (!"valueOf".equals(method.getName()) || !Modifier.isStatic(method.getModifiers())) continue;
                KNOWN_NON_NULL_METHODS.add(method);
            }
        }
        NOT_BINARY_COMPLEMENT = new EnumMap<ExpressionType, ExpressionType>(ExpressionType.class);
        OptimizeShuttle.addComplement(ExpressionType.Equal, ExpressionType.NotEqual);
        OptimizeShuttle.addComplement(ExpressionType.GreaterThanOrEqual, ExpressionType.LessThan);
        OptimizeShuttle.addComplement(ExpressionType.GreaterThan, ExpressionType.LessThanOrEqual);
        BOOLEAN_VALUEOF_BOOL = Types.lookupMethod(Boolean.class, "valueOf", Boolean.TYPE);
    }
}

