/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTableIOReader
extends PTransform<PCollection<String>, PCollection<Row>>
implements Serializable {
    private String filePattern;
    protected RowType rowType;
    protected CSVFormat csvFormat;

    public BeamTextCSVTableIOReader(RowType rowType, String filePattern, CSVFormat csvFormat) {
        this.filePattern = filePattern;
        this.rowType = rowType;
        this.csvFormat = csvFormat;
    }

    public PCollection<Row> expand(PCollection<String> input) {
        return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, Row>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                String str = (String)ctx.element();
                ctx.output((Object)BeamTableUtils.csvLine2BeamRow(BeamTextCSVTableIOReader.this.csvFormat, str, BeamTextCSVTableIOReader.this.rowType));
            }
        }));
    }
}

