/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOReader;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOWriter;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowType;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTable
extends BeamTextTable {
    private String filePattern;
    private CSVFormat csvFormat;

    public BeamTextCSVTable(RowType beamRowType, String filePattern) {
        this(beamRowType, filePattern, CSVFormat.DEFAULT);
    }

    public BeamTextCSVTable(RowType rowType, String filePattern, CSVFormat csvFormat) {
        super(rowType, filePattern);
        this.filePattern = filePattern;
        this.csvFormat = csvFormat;
    }

    @Override
    public PCollection<Row> buildIOReader(Pipeline pipeline) {
        return (PCollection)((PCollection)PBegin.in((Pipeline)pipeline).apply("decodeRecord", (PTransform)TextIO.read().from(this.filePattern))).apply("parseCSVLine", (PTransform)new BeamTextCSVTableIOReader(this.rowType, this.filePattern, this.csvFormat));
    }

    @Override
    public PTransform<? super PCollection<Row>, PDone> buildIOWriter() {
        return new BeamTextCSVTableIOWriter(this.rowType, this.filePattern, this.csvFormat);
    }

    public CSVFormat getCsvFormat() {
        return this.csvFormat;
    }

    public String getFilePattern() {
        return this.filePattern;
    }
}

